/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebe;

public enum ImportValueType {
    PROCESS_INSTANCE("process-instance"),
    DECISION("decision"),
    DECISION_REQUIREMENTS("decision-requirements"),
    DECISION_EVALUATION("decision-evaluation"),
    JOB("job"),
    INCIDENT("incident"),
    PROCESS("process"),
    VARIABLE("variable"),
    VARIABLE_DOCUMENT("variable-document"),
    PROCESS_MESSAGE_SUBSCRIPTION("process-message-subscription"),
    USER_TASK("user-task");

    public static final ImportValueType[] IMPORT_VALUE_TYPES;
    private final String aliasTemplate;

    private ImportValueType(String aliasTemplate) {
        this.aliasTemplate = aliasTemplate;
    }

    public String getAliasTemplate() {
        return this.aliasTemplate;
    }

    public String getIndicesPattern(String prefix) {
        return String.format("%s*%s*", prefix, this.aliasTemplate);
    }

    public String getAliasName(String prefix) {
        return String.format("%s-%s", prefix, this.aliasTemplate);
    }

    static {
        IMPORT_VALUE_TYPES = new ImportValueType[]{PROCESS, DECISION, DECISION_REQUIREMENTS, DECISION_EVALUATION, PROCESS_INSTANCE, JOB, INCIDENT, VARIABLE, VARIABLE_DOCUMENT, PROCESS_MESSAGE_SUBSCRIPTION, USER_TASK};
    }
}

