/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.SequenceFlowEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SequenceFlowZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequenceFlowZeebeRecordProcessor.class);
    private static final String ID_PATTERN = "%s_%s";
    @Autowired
    private SequenceFlowTemplate sequenceFlowTemplate;

    public void processSequenceFlowRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        if (intentStr.equals(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN.name())) {
            ProcessInstanceRecordValue recordValue = (ProcessInstanceRecordValue)record.getValue();
            this.persistSequenceFlow(record, recordValue, batchRequest);
        }
    }

    private void persistSequenceFlow(Record record, ProcessInstanceRecordValue recordValue, BatchRequest batchRequest) throws PersistenceException {
        SequenceFlowEntity entity = ((SequenceFlowEntity)new SequenceFlowEntity().setId(String.format(ID_PATTERN, recordValue.getProcessInstanceKey(), recordValue.getElementId()))).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setActivityId(recordValue.getElementId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        LOGGER.debug("Index sequence flow: id {}", (Object)entity.getId());
        batchRequest.add(this.sequenceFlowTemplate.getFullQualifiedName(), (OperateEntity)entity);
    }
}

