/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.camunda.operate.Metrics;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.ImportStore;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.zeebe.ImportValueType;
import io.camunda.operate.zeebeimport.AbstractImportBatchProcessor;
import io.camunda.operate.zeebeimport.ImportBatch;
import io.camunda.operate.zeebeimport.processors.DecisionEvaluationZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.DecisionRequirementsZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.DecisionZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.EventZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.FlowNodeInstanceZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.IncidentZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.JobZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.ListViewZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.OperationZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.ProcessZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.SequenceFlowZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.UserTaskZeebeRecordProcessor;
import io.camunda.operate.zeebeimport.processors.VariableZeebeRecordProcessor;
import io.camunda.zeebe.protocol.jackson.ZeebeProtocolModule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ImportBulkProcessor
extends AbstractImportBatchProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportBulkProcessor.class);
    @Autowired
    private ListViewZeebeRecordProcessor listViewZeebeRecordProcessor;
    @Autowired
    private FlowNodeInstanceZeebeRecordProcessor flowNodeInstanceZeebeRecordProcessor;
    @Autowired
    private VariableZeebeRecordProcessor variableZeebeRecordProcessor;
    @Autowired
    private OperationZeebeRecordProcessor operationZeebeRecordProcessor;
    @Autowired
    private IncidentZeebeRecordProcessor incidentZeebeRecordProcessor;
    @Autowired
    private ProcessZeebeRecordProcessor processZeebeRecordProcessor;
    @Autowired
    private EventZeebeRecordProcessor eventZeebeRecordProcessor;
    @Autowired
    private JobZeebeRecordProcessor jobZeebeRecordProcessor;
    @Autowired
    private SequenceFlowZeebeRecordProcessor sequenceFlowZeebeRecordProcessor;
    @Autowired
    private DecisionZeebeRecordProcessor decisionZeebeRecordProcessor;
    @Autowired
    private DecisionRequirementsZeebeRecordProcessor decisionRequirementsZeebeRecordProcessor;
    @Autowired
    private DecisionEvaluationZeebeRecordProcessor decisionEvaluationZeebeRecordProcessor;
    @Autowired
    private UserTaskZeebeRecordProcessor userTaskZeebeRecordProcessor;
    @Autowired
    private Metrics metrics;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private ImportStore importStore;
    private ObjectMapper localObjectMapper;

    private static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, JavaType valueType) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, valueType);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error while reading entity of type %s from indices!", valueType.toString()), (Throwable)e);
            throw new OperateRuntimeException(String.format("Error while reading entity of type %s from indices!", valueType), (Throwable)e);
        }
        return (T)entity;
    }

    protected void processZeebeRecords(ImportBatch importBatch, BatchRequest batchRequest) throws PersistenceException {
        List hits = importBatch.getHits();
        List zeebeRecords = CollectionUtil.map((Collection)hits, hit -> (Record)ImportBulkProcessor.fromSearchHit(hit.getSourceAsString(), this.getLocalObjectMapper(), (JavaType)SimpleType.constructUnsafe(Record.class)));
        LOGGER.debug("Writing {} Zeebe records to indices, version={}, importValueType={}, partition={}", new Object[]{zeebeRecords.size(), this.getZeebeVersion(), importBatch.getImportValueType(), importBatch.getPartitionId()});
        boolean concurrencyMode = this.importStore.getConcurrencyMode();
        ImportValueType importValueType = importBatch.getImportValueType();
        switch (importValueType) {
            case DECISION: {
                this.processDecisionRecords(batchRequest, zeebeRecords);
                break;
            }
            case DECISION_REQUIREMENTS: {
                this.processDecisionRequirementsRecord(batchRequest, zeebeRecords);
                break;
            }
            case DECISION_EVALUATION: {
                this.processDecisionEvaluationRecords(batchRequest, zeebeRecords);
                break;
            }
            case PROCESS_INSTANCE: {
                this.processProcessInstanceRecords(importBatch, batchRequest, zeebeRecords, concurrencyMode);
                break;
            }
            case INCIDENT: {
                this.processIncidentRecords(batchRequest, zeebeRecords, concurrencyMode);
                break;
            }
            case VARIABLE: {
                this.processVariableRecords(batchRequest, zeebeRecords, concurrencyMode);
                break;
            }
            case VARIABLE_DOCUMENT: {
                this.processVariableDocumentRecords(batchRequest, zeebeRecords);
                break;
            }
            case PROCESS: {
                this.processProcessRecords(batchRequest, zeebeRecords);
                break;
            }
            case JOB: {
                this.processJobRecords(batchRequest, zeebeRecords, concurrencyMode);
                break;
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                this.processProcessMessageSubscription(batchRequest, zeebeRecords, concurrencyMode);
                break;
            }
            case USER_TASK: {
                this.processUserTask(batchRequest, zeebeRecords);
                break;
            }
            default: {
                LOGGER.debug("Default case triggered for type {}", (Object)importValueType);
            }
        }
        this.recordRecordImportTime(zeebeRecords);
    }

    private void recordRecordImportTime(List<Record> zeebeRecords) {
        long currentTime = OffsetDateTime.now().toInstant().toEpochMilli();
        zeebeRecords.forEach(record -> this.metrics.getTimer("operate.import.time", new String[]{"type", record.getValueType().name(), "partition", String.valueOf(record.getPartitionId())}).record(currentTime - record.getTimestamp(), TimeUnit.MILLISECONDS));
    }

    private void processProcessMessageSubscription(BatchRequest batchRequest, List<Record> zeebeRecords, boolean concurrencyMode) throws PersistenceException {
        Map<Long, List<Record<ProcessMessageSubscriptionRecordValue>>> groupedRecordsPerFlowNodeInst = zeebeRecords.stream().map(obj -> obj).collect(Collectors.groupingBy(obj -> ((ProcessMessageSubscriptionRecordValue)obj.getValue()).getElementInstanceKey()));
        this.eventZeebeRecordProcessor.processProcessMessageSubscription(groupedRecordsPerFlowNodeInst, batchRequest, concurrencyMode);
    }

    private ObjectMapper getLocalObjectMapper() {
        if (this.localObjectMapper == null) {
            this.localObjectMapper = this.objectMapper.copy().registerModule((Module)new ZeebeProtocolModule());
        }
        return this.localObjectMapper;
    }

    private void processDecisionRecords(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.decisionZeebeRecordProcessor.processDecisionRecord(record, batchRequest);
        }
    }

    private void processDecisionRequirementsRecord(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.decisionRequirementsZeebeRecordProcessor.processDecisionRequirementsRecord(record, batchRequest);
        }
    }

    private void processDecisionEvaluationRecords(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.decisionEvaluationZeebeRecordProcessor.processDecisionEvaluationRecord(record, batchRequest);
        }
    }

    private void processJobRecords(BatchRequest batchRequest, List<Record> zeebeRecords, boolean concurrencyMode) throws PersistenceException {
        Map<Long, List<Record<JobRecordValue>>> groupedJobRecordsPerActivityInst = zeebeRecords.stream().map(obj -> obj).collect(Collectors.groupingBy(obj -> ((JobRecordValue)obj.getValue()).getElementInstanceKey()));
        this.listViewZeebeRecordProcessor.processJobRecords(groupedJobRecordsPerActivityInst, batchRequest, concurrencyMode);
        this.eventZeebeRecordProcessor.processJobRecords(groupedJobRecordsPerActivityInst, batchRequest, concurrencyMode);
        this.jobZeebeRecordProcessor.processJobRecords(groupedJobRecordsPerActivityInst, batchRequest, concurrencyMode);
    }

    private void processProcessRecords(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.processZeebeRecordProcessor.processDeploymentRecord(record, batchRequest);
        }
    }

    private void processVariableDocumentRecords(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.operationZeebeRecordProcessor.processVariableDocumentRecords(record, batchRequest);
        }
    }

    private void processVariableRecords(BatchRequest batchRequest, List<Record> zeebeRecords, boolean concurrencyMode) throws PersistenceException {
        Map<Long, List<Record<VariableRecordValue>>> variablesGroupedByScopeKey = zeebeRecords.stream().map(obj -> obj).collect(Collectors.groupingBy(obj -> ((VariableRecordValue)obj.getValue()).getScopeKey()));
        this.listViewZeebeRecordProcessor.processVariableRecords(variablesGroupedByScopeKey, batchRequest, concurrencyMode);
        this.variableZeebeRecordProcessor.processVariableRecords(variablesGroupedByScopeKey, batchRequest, concurrencyMode);
    }

    private void processIncidentRecords(BatchRequest batchRequest, List<Record> zeebeRecords, boolean concurrencyMode) throws PersistenceException {
        this.incidentZeebeRecordProcessor.processIncidentRecord(zeebeRecords, batchRequest, concurrencyMode);
        for (Record record : zeebeRecords) {
            this.listViewZeebeRecordProcessor.processIncidentRecord(record, batchRequest, concurrencyMode);
            this.flowNodeInstanceZeebeRecordProcessor.processIncidentRecord(record, batchRequest);
        }
        Map<Long, List<Record<IncidentRecordValue>>> groupedIncidentRecordsPerActivityInst = zeebeRecords.stream().map(obj -> obj).collect(Collectors.groupingBy(obj -> ((IncidentRecordValue)obj.getValue()).getElementInstanceKey()));
        this.eventZeebeRecordProcessor.processIncidentRecords(groupedIncidentRecordsPerActivityInst, batchRequest, concurrencyMode);
    }

    private void processProcessInstanceRecords(ImportBatch importBatch, BatchRequest batchRequest, List<Record> zeebeRecords, boolean concurrencyMode) throws PersistenceException {
        Map groupedWIRecords = zeebeRecords.stream().map(obj -> obj).collect(LinkedHashMap::new, (map, item) -> CollectionUtil.addToMap((Map)map, (Object)((ProcessInstanceRecordValue)item.getValue()).getProcessInstanceKey(), (Object)item), Map::putAll);
        this.listViewZeebeRecordProcessor.processProcessInstanceRecord(groupedWIRecords, batchRequest, importBatch, concurrencyMode);
        Map<Long, List<Record<ProcessInstanceRecordValue>>> groupedWIRecordsPerActivityInst = zeebeRecords.stream().map(obj -> obj).collect(Collectors.groupingBy(obj -> obj.getKey()));
        List<Long> flowNodeInstanceKeysOrdered = zeebeRecords.stream().map(Record::getKey).distinct().collect(Collectors.toList());
        this.flowNodeInstanceZeebeRecordProcessor.processProcessInstanceRecord(groupedWIRecordsPerActivityInst, flowNodeInstanceKeysOrdered, batchRequest);
        this.eventZeebeRecordProcessor.processProcessInstanceRecords(groupedWIRecordsPerActivityInst, batchRequest, concurrencyMode);
        for (Record record : zeebeRecords) {
            this.sequenceFlowZeebeRecordProcessor.processSequenceFlowRecord(record, batchRequest);
        }
    }

    private void processUserTask(BatchRequest batchRequest, List<Record> zeebeRecords) throws PersistenceException {
        for (Record record : zeebeRecords) {
            this.userTaskZeebeRecordProcessor.processUserTaskRecord(batchRequest, (Record<UserTaskRecordValue>)record);
        }
    }

    public String getZeebeVersion() {
        return "8.6";
    }
}

