/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.Metrics;
import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.FlowNodeStore;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.zeebe.PartitionHolder;
import io.camunda.operate.zeebeimport.cache.FlowNodeInstanceTreePathCache;
import io.camunda.operate.zeebeimport.cache.TreePathCache;
import io.camunda.operate.zeebeimport.cache.TreePathCacheMetrics;
import io.camunda.operate.zeebeimport.cache.TreePathCacheMetricsImpl;
import io.camunda.operate.zeebeimport.processors.fni.FNITransformer;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FlowNodeInstanceZeebeRecordProcessor {
    public static final Set<String> AI_FINISH_STATES = Set.of(ProcessInstanceIntent.ELEMENT_COMPLETED.name(), ProcessInstanceIntent.ELEMENT_TERMINATED.name());
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowNodeInstanceZeebeRecordProcessor.class);
    private static final Set<String> AI_START_STATES = Set.of(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
    private final ConcurrentInitializer<FNITransformer> fniTransformerLazy;
    private final FlowNodeInstanceTemplate flowNodeInstanceTemplate;

    public FlowNodeInstanceZeebeRecordProcessor(FlowNodeStore flowNodeStore, FlowNodeInstanceTemplate flowNodeInstanceTemplate, OperateProperties operateProperties, PartitionHolder partitionHolder, Metrics metrics) {
        this.flowNodeInstanceTemplate = flowNodeInstanceTemplate;
        int flowNodeTreeCacheSize = operateProperties.getImporter().getFlowNodeTreeCacheSize();
        this.fniTransformerLazy = ((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(FlowNodeInstanceZeebeRecordProcessor.createFNITransformerSupplier(flowNodeStore, partitionHolder, metrics, flowNodeTreeCacheSize))).get();
    }

    private static FailableSupplier<FNITransformer, Exception> createFNITransformerSupplier(FlowNodeStore flowNodeStore, PartitionHolder partitionHolder, Metrics metrics, int flowNodeTreeCacheSize) {
        return () -> {
            List partitionIds = partitionHolder.getPartitionIds();
            FlowNodeInstanceTreePathCache treePathCache = new FlowNodeInstanceTreePathCache(partitionIds, flowNodeTreeCacheSize, arg_0 -> ((FlowNodeStore)flowNodeStore).findParentTreePathFor(arg_0), (TreePathCacheMetrics)new TreePathCacheMetricsImpl(partitionIds, metrics));
            return new FNITransformer((TreePathCache)treePathCache);
        };
    }

    private FNITransformer getFNITransformer() {
        try {
            return (FNITransformer)this.fniTransformerLazy.get();
        }
        catch (ConcurrentException e) {
            throw new RuntimeException("Expected to retrieve FNITransformer without an error, but caught one.", e);
        }
    }

    public void processIncidentRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        IncidentRecordValue recordValue = (IncidentRecordValue)record.getValue();
        FlowNodeInstanceEntity entity = ((FlowNodeInstanceEntity)((FlowNodeInstanceEntity)((FlowNodeInstanceEntity)new FlowNodeInstanceEntity().setId(ConversionUtils.toStringOrNull((Object)recordValue.getElementInstanceKey()))).setKey(recordValue.getElementInstanceKey())).setPartitionId(record.getPartitionId())).setFlowNodeId(recordValue.getElementId()).setProcessInstanceKey(Long.valueOf(recordValue.getProcessInstanceKey())).setProcessDefinitionKey(Long.valueOf(recordValue.getProcessDefinitionKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setTenantId(ImportUtil.tenantOrDefault((String)recordValue.getTenantId()));
        if (intentStr.equals(IncidentIntent.CREATED.name())) {
            entity.setIncidentKey(Long.valueOf(record.getKey()));
        } else if (intentStr.equals(IncidentIntent.RESOLVED.name())) {
            entity.setIncidentKey(null);
        }
        LOGGER.debug("Flow node instance: id {}", (Object)entity.getId());
        HashMap<String, Long> updateFields = new HashMap<String, Long>();
        updateFields.put("incidentKey", entity.getIncidentKey());
        batchRequest.upsert(this.flowNodeInstanceTemplate.getFullQualifiedName(), entity.getId(), (OperateEntity)entity, updateFields);
    }

    public void processProcessInstanceRecord(Map<Long, List<Record<ProcessInstanceRecordValue>>> records, List<Long> flowNodeInstanceKeysOrdered, BatchRequest batchRequest) throws PersistenceException {
        for (Long key : flowNodeInstanceKeysOrdered) {
            List<Record<ProcessInstanceRecordValue>> wiRecords = records.get(key);
            FlowNodeInstanceEntity fniEntity = null;
            for (Record<ProcessInstanceRecordValue> record : wiRecords) {
                if (!this.shouldProcessProcessInstanceRecord(record)) continue;
                fniEntity = this.getFNITransformer().toFlowNodeInstanceEntity(record, fniEntity);
            }
            if (fniEntity == null) continue;
            LOGGER.debug("Flow node instance: id {}", (Object)fniEntity.getId());
            if (this.canOptimizeFlowNodeInstanceIndexing(fniEntity)) {
                batchRequest.add(this.flowNodeInstanceTemplate.getFullQualifiedName(), (OperateEntity)fniEntity);
                continue;
            }
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("id", fniEntity.getId());
            updateFields.put("partitionId", fniEntity.getPartitionId());
            updateFields.put("type", fniEntity.getType());
            updateFields.put("state", fniEntity.getState());
            updateFields.put("flowNodeId", fniEntity.getFlowNodeId());
            updateFields.put("processDefinitionKey", fniEntity.getProcessDefinitionKey());
            updateFields.put("bpmnProcessId", fniEntity.getBpmnProcessId());
            if (fniEntity.getTreePath() != null) {
                updateFields.put("treePath", fniEntity.getTreePath());
                updateFields.put("level", fniEntity.getLevel());
            }
            if (fniEntity.getStartDate() != null) {
                updateFields.put("startDate", fniEntity.getStartDate());
            }
            if (fniEntity.getEndDate() != null) {
                updateFields.put("endDate", fniEntity.getEndDate());
            }
            if (fniEntity.getPosition() != null) {
                updateFields.put("position", fniEntity.getPosition());
            }
            batchRequest.upsert(this.flowNodeInstanceTemplate.getFullQualifiedName(), fniEntity.getId(), (OperateEntity)fniEntity, updateFields);
        }
    }

    private boolean shouldProcessProcessInstanceRecord(Record<ProcessInstanceRecordValue> processInstanceRecord) {
        ProcessInstanceRecordValue processInstanceRecordValue = (ProcessInstanceRecordValue)processInstanceRecord.getValue();
        String intent = processInstanceRecord.getIntent().name();
        return !this.isProcessEvent(processInstanceRecordValue) && (AI_START_STATES.contains(intent) || AI_FINISH_STATES.contains(intent) || ProcessInstanceIntent.ELEMENT_MIGRATED.name().equals(intent));
    }

    private boolean canOptimizeFlowNodeInstanceIndexing(FlowNodeInstanceEntity entity) {
        OffsetDateTime startDate = entity.getStartDate();
        OffsetDateTime endDate = entity.getEndDate();
        if (startDate != null && endDate != null) {
            Duration duration = Duration.between(startDate, endDate);
            return duration.getSeconds() <= 2L;
        }
        return false;
    }

    private boolean isProcessEvent(ProcessInstanceRecordValue recordValue) {
        return this.isOfType(recordValue, BpmnElementType.PROCESS);
    }

    private boolean isOfType(ProcessInstanceRecordValue recordValue, BpmnElementType type) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return bpmnElementType.equals((Object)type);
    }
}

