/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DecisionZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionZeebeRecordProcessor.class);
    private static final Set<String> STATES = new HashSet<String>();
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private DecisionIndex decisionIndex;

    public void processDecisionRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        String intentStr = record.getIntent().name();
        if (STATES.contains(intentStr)) {
            DecisionRecordValue decision = (DecisionRecordValue)record.getValue();
            this.persistDecision(decision, batchRequest);
        }
    }

    private void persistDecision(DecisionRecordValue decision, BatchRequest batchRequest) throws PersistenceException {
        DecisionDefinitionEntity decisionEntity = this.createEntity(decision);
        LOGGER.debug("Decision: key {}, decisionId {}", (Object)decisionEntity.getKey(), (Object)decisionEntity.getDecisionId());
        batchRequest.addWithId(this.decisionIndex.getFullQualifiedName(), ConversionUtils.toStringOrNull((Object)decisionEntity.getKey()), (OperateEntity)decisionEntity);
    }

    private DecisionDefinitionEntity createEntity(DecisionRecordValue decision) {
        return ((DecisionDefinitionEntity)((DecisionDefinitionEntity)new DecisionDefinitionEntity().setId(String.valueOf(decision.getDecisionKey()))).setKey(decision.getDecisionKey())).setName(decision.getDecisionName()).setVersion(decision.getVersion()).setDecisionId(decision.getDecisionId()).setDecisionRequirementsId(decision.getDecisionRequirementsId()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()).setTenantId(ImportUtil.tenantOrDefault((String)decision.getTenantId()));
    }

    static {
        STATES.add(ProcessIntent.CREATED.name());
    }
}

