/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.processors;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceInputEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceOutputEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceState;
import io.camunda.operate.entities.dmn.DecisionType;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.MetricsStore;
import io.camunda.operate.util.DateUtil;
import io.camunda.operate.zeebeimport.util.ImportUtil;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DecisionEvaluationZeebeRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionEvaluationZeebeRecordProcessor.class);
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;
    @Autowired
    private MetricsStore metricsStore;

    public void processDecisionEvaluationRecord(Record record, BatchRequest batchRequest) throws PersistenceException {
        DecisionEvaluationRecordValue decision = (DecisionEvaluationRecordValue)record.getValue();
        this.persistDecisionInstance(record, decision, batchRequest);
    }

    private void persistDecisionInstance(Record record, DecisionEvaluationRecordValue decisionEvaluation, BatchRequest batchRequest) throws PersistenceException {
        List<DecisionInstanceEntity> decisionEntities = this.createEntities(record, decisionEvaluation);
        LOGGER.debug("Decision evaluation: key {}, decisionId {}", (Object)record.getKey(), (Object)decisionEvaluation.getDecisionId());
        OffsetDateTime timestamp = DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp()));
        for (DecisionInstanceEntity entity : decisionEntities) {
            batchRequest.add(this.decisionInstanceTemplate.getFullQualifiedName(), (OperateEntity)entity);
            this.metricsStore.registerDecisionInstanceCompleteEvent(entity.getId(), decisionEvaluation.getTenantId(), timestamp, batchRequest);
        }
    }

    private List<DecisionInstanceEntity> createEntities(Record record, DecisionEvaluationRecordValue decisionEvaluation) {
        ArrayList<DecisionInstanceEntity> entities = new ArrayList<DecisionInstanceEntity>();
        for (int i = 1; i <= decisionEvaluation.getEvaluatedDecisions().size(); ++i) {
            EvaluatedDecisionValue decision = (EvaluatedDecisionValue)decisionEvaluation.getEvaluatedDecisions().get(i - 1);
            OffsetDateTime timestamp = DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp()));
            DecisionInstanceState state = this.getState(record, decisionEvaluation, i);
            DecisionInstanceEntity entity = ((DecisionInstanceEntity)((DecisionInstanceEntity)new DecisionInstanceEntity().setId(Long.valueOf(record.getKey()), i).setKey(record.getKey())).setExecutionIndex(Integer.valueOf(i)).setPosition(Long.valueOf(record.getPosition())).setPartitionId(record.getPartitionId())).setEvaluationDate(timestamp).setProcessInstanceKey(decisionEvaluation.getProcessInstanceKey()).setProcessDefinitionKey(decisionEvaluation.getProcessDefinitionKey()).setBpmnProcessId(decisionEvaluation.getBpmnProcessId()).setElementInstanceKey(decisionEvaluation.getElementInstanceKey()).setElementId(decisionEvaluation.getElementId()).setDecisionRequirementsKey(decisionEvaluation.getDecisionRequirementsKey()).setDecisionRequirementsId(decisionEvaluation.getDecisionRequirementsId()).setRootDecisionId(decisionEvaluation.getDecisionId()).setRootDecisionName(decisionEvaluation.getDecisionName()).setRootDecisionDefinitionId(String.valueOf(decisionEvaluation.getDecisionKey())).setDecisionId(decision.getDecisionId()).setDecisionDefinitionId(String.valueOf(decision.getDecisionKey())).setDecisionType(DecisionType.fromZeebeDecisionType((String)decision.getDecisionType())).setDecisionName(decision.getDecisionName()).setDecisionVersion(decision.getDecisionVersion()).setState(state).setResult(decision.getDecisionOutput()).setEvaluatedOutputs(this.createEvaluationOutputs(decision.getMatchedRules())).setEvaluatedInputs(this.createEvaluationInputs(decision.getEvaluatedInputs())).setTenantId(ImportUtil.tenantOrDefault((String)decisionEvaluation.getTenantId()));
            if (state.equals((Object)DecisionInstanceState.FAILED)) {
                entity.setEvaluationFailure(decisionEvaluation.getEvaluationFailureMessage());
            }
            entities.add(entity);
        }
        return entities;
    }

    private DecisionInstanceState getState(Record record, DecisionEvaluationRecordValue decisionEvaluation, int i) {
        if (record.getIntent().name().equals(DecisionEvaluationIntent.FAILED.name()) && i == decisionEvaluation.getEvaluatedDecisions().size()) {
            return DecisionInstanceState.FAILED;
        }
        return DecisionInstanceState.EVALUATED;
    }

    private List<DecisionInstanceInputEntity> createEvaluationInputs(List<EvaluatedInputValue> evaluatedInputs) {
        return evaluatedInputs.stream().map(input -> new DecisionInstanceInputEntity().setId(input.getInputId()).setName(input.getInputName()).setValue(input.getInputValue())).collect(Collectors.toList());
    }

    private List<DecisionInstanceOutputEntity> createEvaluationOutputs(List<MatchedRuleValue> matchedRules) {
        ArrayList<DecisionInstanceOutputEntity> outputs = new ArrayList<DecisionInstanceOutputEntity>();
        matchedRules.stream().forEach(rule -> outputs.addAll(rule.getEvaluatedOutputs().stream().map(output -> new DecisionInstanceOutputEntity().setRuleId(rule.getRuleId()).setRuleIndex(rule.getRuleIndex()).setId(output.getOutputId()).setName(output.getOutputName()).setValue(output.getOutputValue())).collect(Collectors.toList())));
        return outputs;
    }
}

