/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.types;

import io.camunda.search.clients.types.TypedValue;
import io.camunda.search.os.transformers.OpensearchTransformer;
import io.camunda.search.os.transformers.OpensearchTransformers;
import org.opensearch.client.opensearch._types.FieldValue;

public final class TypedValueTransformer
extends OpensearchTransformer<TypedValue, FieldValue> {
    public TypedValueTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public FieldValue apply(TypedValue value) {
        if (value.isString()) {
            return FieldValue.of((String)value.stringValue());
        }
        if (value.isInteger()) {
            return FieldValue.of((long)value.intValue());
        }
        if (value.isLong()) {
            return FieldValue.of((long)value.longValue());
        }
        if (value.isBoolean()) {
            return FieldValue.of((boolean)value.booleanValue());
        }
        if (value.isDouble()) {
            return FieldValue.of((double)value.doubleValue());
        }
        if (value.isNull()) {
            return FieldValue.NULL;
        }
        throw new IllegalArgumentException("Unsupported type for TypedValue");
    }
}

