/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.query;

import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.os.transformers.OpensearchTransformers;
import io.camunda.search.os.transformers.query.QueryOptionTransformer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.MatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;

public final class MatchQueryTransformer
extends QueryOptionTransformer<SearchMatchQuery, MatchQuery> {
    public MatchQueryTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public MatchQuery apply(SearchMatchQuery value) {
        String field = value.field();
        String query = value.query();
        FieldValue queryAsFieldValue = FieldValue.of((String)query);
        SearchMatchQuery.SearchMatchQueryOperator operator = value.operator();
        MatchQuery.Builder builder = QueryBuilders.match().field(field).query(queryAsFieldValue);
        if (operator != null) {
            switch (operator) {
                case AND: {
                    builder.operator(Operator.And);
                    break;
                }
                case OR: {
                    builder.operator(Operator.Or);
                    break;
                }
            }
        }
        return builder.build();
    }
}

