/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.util;

import io.camunda.search.connect.SearchClientConnectException;
import io.camunda.search.connect.configuration.SecurityConfiguration;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtil.class);

    private SecurityUtil() {
    }

    public static SSLContext getSSLContext(SecurityConfiguration configuration, String alias) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy;
        KeyStore trustStore = SecurityUtil.loadCustomTrustStore(configuration);
        String certificatePath = configuration.getCertificatePath();
        if (certificatePath != null) {
            Certificate certificate = SecurityUtil.loadCertificateFromPath(certificatePath);
            SecurityUtil.setCertificateInTrustStore(trustStore, certificate, alias);
        }
        TrustSelfSignedStrategy trustSelfSignedStrategy = trustStrategy = configuration.isSelfSigned() ? new TrustSelfSignedStrategy() : null;
        if (trustStore.size() > 0) {
            return SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)trustStrategy).build();
        }
        return SSLContext.getDefault();
    }

    private static KeyStore loadCustomTrustStore(SecurityConfiguration configuration) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            return trustStore;
        }
        catch (Exception e) {
            String message = "Could not create certificate trustStore for the secured OpenSearch Connection!";
            throw new SearchClientConnectException("Could not create certificate trustStore for the secured OpenSearch Connection!", e);
        }
    }

    private static Certificate loadCertificateFromPath(String certificatePath) {
        Certificate cert;
        block8: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certificatePath));){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() > 0) {
                    cert = cf.generateCertificate(bis);
                    LOGGER.debug("Found certificate: {}", (Object)cert);
                    break block8;
                }
                throw new SearchClientConnectException("Could not load certificate from file, file is empty. File: " + certificatePath);
            }
            catch (Exception e) {
                String message = "Could not load configured server certificate for the secured Connection!";
                throw new SearchClientConnectException("Could not load configured server certificate for the secured Connection!", e);
            }
        }
        return cert;
    }

    public static void setCertificateInTrustStore(KeyStore trustStore, Certificate certificate, String alias) {
        try {
            trustStore.setCertificateEntry(alias, certificate);
        }
        catch (Exception e) {
            String message = "Could not set configured server certificate in trust store!";
            throw new SearchClientConnectException("Could not set configured server certificate in trust store!", e);
        }
    }
}

