/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.MessageSubscriptionState;
import io.camunda.client.api.search.response.MessageSubscription;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.MessageSubscriptionResult;
import java.time.OffsetDateTime;
import java.util.Objects;

public class MessageSubscriptionImpl
implements MessageSubscription {
    private final Long messageSubscriptionKey;
    private final String processDefinitionId;
    private final Long processDefinitionKey;
    private final Long processInstanceKey;
    private final String elementId;
    private final Long elementInstanceKey;
    private final MessageSubscriptionState messageSubscriptionState;
    private final OffsetDateTime lastUpdatedDate;
    private final String messageName;
    private final String correlationKey;
    private final String tenantId;

    public MessageSubscriptionImpl(MessageSubscriptionResult item) {
        this.messageSubscriptionKey = ParseUtil.parseLongOrNull(item.getMessageSubscriptionKey());
        this.processDefinitionId = item.getProcessDefinitionId();
        this.processDefinitionKey = ParseUtil.parseLongOrNull(item.getProcessDefinitionKey());
        this.processInstanceKey = ParseUtil.parseLongOrNull(item.getProcessInstanceKey());
        this.elementId = item.getElementId();
        this.elementInstanceKey = ParseUtil.parseLongOrNull(item.getElementInstanceKey());
        this.messageSubscriptionState = EnumUtil.convert(item.getMessageSubscriptionState(), MessageSubscriptionState.class);
        this.lastUpdatedDate = ParseUtil.parseOffsetDateTimeOrNull(item.getLastUpdatedDate());
        this.messageName = item.getMessageName();
        this.correlationKey = item.getCorrelationKey();
        this.tenantId = item.getTenantId();
    }

    @Override
    public Long getMessageSubscriptionKey() {
        return this.messageSubscriptionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public Long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public MessageSubscriptionState getMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    @Override
    public OffsetDateTime getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageSubscriptionKey, this.processDefinitionId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.messageSubscriptionState, this.lastUpdatedDate, this.messageName, this.correlationKey, this.tenantId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSubscriptionImpl subscription = (MessageSubscriptionImpl)o;
        return Objects.equals(this.messageSubscriptionKey, subscription.messageSubscriptionKey) && Objects.equals(this.processDefinitionId, subscription.processDefinitionId) && Objects.equals(this.processDefinitionKey, subscription.processDefinitionKey) && Objects.equals(this.processInstanceKey, subscription.processInstanceKey) && Objects.equals(this.elementId, subscription.elementId) && Objects.equals(this.elementInstanceKey, subscription.elementInstanceKey) && this.messageSubscriptionState == subscription.messageSubscriptionState && Objects.equals(this.lastUpdatedDate, subscription.lastUpdatedDate) && Objects.equals(this.messageName, subscription.messageName) && Objects.equals(this.correlationKey, subscription.correlationKey) && Objects.equals(this.tenantId, subscription.tenantId);
    }
}

