/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.BatchOperationItemSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.BatchOperationItems;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.BatchOperationItemSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.BatchOperationItemFilter;
import io.camunda.client.protocol.rest.BatchOperationItemSearchQuery;
import io.camunda.client.protocol.rest.BatchOperationItemSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class BatchOperationItemSearchRequestImpl
extends TypedSearchRequestPropertyProvider<BatchOperationItemSearchQuery>
implements BatchOperationItemSearchRequest {
    private final BatchOperationItemSearchQuery request = new BatchOperationItemSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public BatchOperationItemSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public BatchOperationItemSearchRequest filter(io.camunda.client.api.search.filter.BatchOperationItemFilter value) {
        this.request.setFilter((BatchOperationItemFilter)BatchOperationItemSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public BatchOperationItemSearchRequest filter(Consumer<io.camunda.client.api.search.filter.BatchOperationItemFilter> fn) {
        return this.filter(SearchRequestBuilders.batchOperationItemFilter(fn));
    }

    @Override
    public BatchOperationItemSearchRequest sort(BatchOperationItemSort value) {
        this.request.setSort(SearchRequestSortMapper.toBatchOperationItemSearchQuerySortRequest((List)BatchOperationItemSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public BatchOperationItemSearchRequest sort(Consumer<BatchOperationItemSort> fn) {
        return this.sort(SearchRequestBuilders.batchOperationItemSort(fn));
    }

    @Override
    public BatchOperationItemSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)BatchOperationItemSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public BatchOperationItemSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected BatchOperationItemSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchRequestStep<BatchOperationItems.BatchOperationItem> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<BatchOperationItems.BatchOperationItem>> send() {
        HttpCamundaFuture<SearchResponse<BatchOperationItems.BatchOperationItem>> result = new HttpCamundaFuture<SearchResponse<BatchOperationItems.BatchOperationItem>>();
        this.httpClient.post("/batch-operation-items/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), BatchOperationItemSearchQueryResult.class, SearchResponseMapper::toBatchOperationItemsResponse, result);
        return result;
    }
}

