/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateAuthorizationCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateAuthorizationResponse;
import io.camunda.client.api.search.enums.OwnerType;
import io.camunda.client.api.search.enums.PermissionType;
import io.camunda.client.api.search.enums.ResourceType;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateAuthorizationResponseImpl;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.protocol.rest.AuthorizationCreateResult;
import io.camunda.client.protocol.rest.AuthorizationRequest;
import io.camunda.client.protocol.rest.OwnerTypeEnum;
import io.camunda.client.protocol.rest.PermissionTypeEnum;
import io.camunda.client.protocol.rest.ResourceTypeEnum;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateAuthorizationCommandImpl
implements CreateAuthorizationCommandStep1,
CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep2,
CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep3,
CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep4,
CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep5,
CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep6 {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;
    private final AuthorizationRequest request;

    public CreateAuthorizationCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new AuthorizationRequest();
    }

    @Override
    public CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep2 ownerId(String ownerId) {
        ArgumentUtil.ensureNotNull("ownerId", ownerId);
        ArgumentUtil.ensureNotEmpty("ownerId", ownerId);
        this.request.setOwnerId(ownerId);
        return this;
    }

    @Override
    public CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep3 ownerType(OwnerType ownerType) {
        ArgumentUtil.ensureNotNull("ownerType", (Object)ownerType);
        this.request.setOwnerType(EnumUtil.convert(ownerType, OwnerTypeEnum.class));
        return this;
    }

    @Override
    public CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep4 resourceId(String resourceId) {
        ArgumentUtil.ensureNotNull("resourceId", resourceId);
        ArgumentUtil.ensureNotEmpty("resourceId", resourceId);
        this.request.setResourceId(resourceId);
        return this;
    }

    @Override
    public CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep5 resourceType(ResourceType resourceType) {
        ArgumentUtil.ensureNotNull("resourceType", (Object)resourceType);
        this.request.setResourceType(EnumUtil.convert(resourceType, ResourceTypeEnum.class));
        return this;
    }

    @Override
    public CreateAuthorizationCommandStep1.CreateAuthorizationCommandStep6 permissionTypes(PermissionType ... permissionTypes) {
        ArgumentUtil.ensureNotNull("permissionTypes", permissionTypes);
        this.request.setPermissionTypes(Arrays.stream(permissionTypes).map(permissionType -> EnumUtil.convert(permissionType, PermissionTypeEnum.class)).collect(Collectors.toList()));
        return this;
    }

    @Override
    public FinalCommandStep<CreateAuthorizationResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateAuthorizationResponse> send() {
        HttpCamundaFuture<CreateAuthorizationResponse> result = new HttpCamundaFuture<CreateAuthorizationResponse>();
        CreateAuthorizationResponseImpl response = new CreateAuthorizationResponseImpl();
        this.httpClient.post("/authorizations", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), AuthorizationCreateResult.class, response::setResponse, result);
        return result;
    }
}

