/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.annotation.endpoint;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.MethodParameter;

public class SnsControllerMappingReflectiveProcessor
implements ReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type = (Class)element;
            this.registerTypeHints(hints, type);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHints(hints, method);
        }
    }

    protected void registerTypeHints(ReflectionHints hints, Class<?> type) {
        hints.registerType(type, new MemberCategory[0]);
    }

    protected void registerMethodHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        for (Parameter parameter : method.getParameters()) {
            this.registerParameterTypeHints(hints, MethodParameter.forParameter((Parameter)parameter));
        }
        this.registerReturnTypeHints(hints, MethodParameter.forExecutable((Executable)method, (int)-1));
    }

    protected void registerParameterTypeHints(ReflectionHints hints, MethodParameter methodParameter) {
        this.bindingRegistrar.registerReflectionHints(hints, new Type[]{methodParameter.getGenericParameterType()});
    }

    protected void registerReturnTypeHints(ReflectionHints hints, MethodParameter returnTypeParameter) {
        this.bindingRegistrar.registerReflectionHints(hints, new Type[]{this.getEntityType(returnTypeParameter)});
    }

    private Type getEntityType(MethodParameter parameter) {
        MethodParameter nestedParameter = parameter.nested();
        return nestedParameter.getNestedParameterType() == nestedParameter.getParameterType() ? null : nestedParameter.getNestedParameterType();
    }
}

