/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultDynamoDbTableNameResolver
implements DynamoDbTableNameResolver {
    @Nullable
    private final String tablePrefix;
    @Nullable
    private final String tableSuffix;
    @Nullable
    private final String tableSeparator;

    public DefaultDynamoDbTableNameResolver() {
        this(null, null, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix) {
        this(tablePrefix, null, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix, @Nullable String tableSuffix) {
        this(tablePrefix, tableSuffix, null);
    }

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix, @Nullable String tableSuffix, @Nullable String tableSeparator) {
        this.tablePrefix = tablePrefix;
        this.tableSuffix = tableSuffix;
        this.tableSeparator = tableSeparator;
    }

    public String resolve(Class clazz) {
        Assert.notNull((Object)clazz, (String)"clazz is required");
        String prefix = StringUtils.hasText((String)this.tablePrefix) ? this.tablePrefix : "";
        String suffix = StringUtils.hasText((String)this.tableSuffix) ? this.tableSuffix : "";
        String separator = StringUtils.hasText((String)this.tableSeparator) ? this.tableSeparator : "_";
        return prefix.concat(clazz.getSimpleName().replaceAll("(.)(\\p{Lu})", "$1" + separator + "$2").toLowerCase(Locale.ROOT)).concat(suffix);
    }
}

