/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.imds;

import io.awspring.cloud.autoconfigure.imds.ImdsUtils;
import io.awspring.cloud.core.config.AwsPropertySource;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;

public class ImdsPropertySource
extends AwsPropertySource<ImdsPropertySource, ImdsUtils> {
    private final String context;
    private final ImdsUtils imdsUtils;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    public ImdsPropertySource(String context, ImdsUtils imdsUtils) {
        super(context, (Object)imdsUtils);
        this.context = context;
        this.imdsUtils = imdsUtils;
    }

    public ImdsPropertySource copy() {
        return new ImdsPropertySource(this.context, (ImdsUtils)this.source);
    }

    public void init() {
        if (!this.imdsUtils.isRunningOnCloudEnvironment()) {
            return;
        }
        this.properties.putAll(this.imdsUtils.getEc2InstanceMetadata());
    }

    public String[] getPropertyNames() {
        return (String[])this.properties.keySet().stream().toArray(String[]::new);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }
}

