/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.astefanutti.metrics.aspectj.MetricStrategy;
import java.util.regex.Matcher;
import javax.el.ELProcessor;

final class JavaxElMetricStrategy
implements MetricStrategy {
    private final ELProcessor processor = new ELProcessor();

    JavaxElMetricStrategy(Object object) {
        this.processor.defineBean("this", object);
    }

    JavaxElMetricStrategy(Class<?> clazz) {
        this.processor.getELManager().importClass(clazz.getName());
    }

    @Override
    public MetricRegistry resolveMetricRegistry(String registry) {
        Matcher matcher = MetricStrategy.EL_PATTERN.matcher(registry);
        if (matcher.matches()) {
            Object evaluation = this.processor.eval(matcher.group(1));
            if (evaluation instanceof String) {
                return SharedMetricRegistries.getOrCreate((String)((String)evaluation));
            }
            if (evaluation instanceof MetricRegistry) {
                return (MetricRegistry)evaluation;
            }
            throw new IllegalStateException("Unable to resolve metrics registry from expression [" + registry + "]");
        }
        if (!matcher.find()) {
            return SharedMetricRegistries.getOrCreate((String)registry);
        }
        return SharedMetricRegistries.getOrCreate((String)this.evaluateCompositeExpression(matcher));
    }

    @Override
    public String resolveMetricName(String name) {
        Matcher matcher = MetricStrategy.EL_PATTERN.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        return this.evaluateCompositeExpression(matcher);
    }

    private String evaluateCompositeExpression(Matcher matcher) {
        StringBuffer buffer = new StringBuffer();
        do {
            Object result;
            matcher.appendReplacement(buffer, (result = this.processor.eval(matcher.group(1))) != null ? String.valueOf(result) : "");
        } while (matcher.find());
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

