/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import io.astefanutti.metrics.aspectj.AnnotatedMetric;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public abstract class AbstractMetricAspect {
    AbstractMetricAspect() {
    }

    protected <T extends Metric> AnnotatedMetric<T> metricAnnotation(Method method, Class<? extends Annotation> clazz, MetricFactory<T> factory) {
        if (method.isAnnotationPresent(clazz)) {
            Annotation annotation = method.getAnnotation(clazz);
            T metric = factory.metric(AbstractMetricAspect.metricAnnotationName(annotation), AbstractMetricAspect.metricAnnotationAbsolute(annotation));
            return new AnnotatedMetric.IsPresent<T>(metric, annotation);
        }
        return new AnnotatedMetric.IsNotPresent();
    }

    protected static String metricAnnotationName(Annotation annotation) {
        if (com.codahale.metrics.annotation.Gauge.class.isInstance(annotation)) {
            return ((com.codahale.metrics.annotation.Gauge)annotation).name();
        }
        if (ExceptionMetered.class.isInstance(annotation)) {
            return ((ExceptionMetered)annotation).name();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).name();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).name();
        }
        throw new IllegalArgumentException("Unsupported Metrics annotation [" + annotation.getClass().getName() + "]");
    }

    protected static boolean metricAnnotationAbsolute(Annotation annotation) {
        if (com.codahale.metrics.annotation.Gauge.class.isInstance(annotation)) {
            return ((com.codahale.metrics.annotation.Gauge)annotation).absolute();
        }
        if (ExceptionMetered.class.isInstance(annotation)) {
            return ((ExceptionMetered)annotation).absolute();
        }
        if (Metered.class.isInstance(annotation)) {
            return ((Metered)annotation).absolute();
        }
        if (Timed.class.isInstance(annotation)) {
            return ((Timed)annotation).absolute();
        }
        throw new IllegalArgumentException("Unsupported Metrics annotation [" + annotation.getClass().getName() + "]");
    }

    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
        catch (InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    protected static class ForwardingGauge
    implements Gauge<Object> {
        final Method method;
        final Object object;

        protected ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            method.setAccessible(true);
        }

        public Object getValue() {
            return AbstractMetricAspect.invokeMethod(this.method, this.object);
        }
    }

    protected static interface MetricFactory<T extends Metric> {
        public T metric(String var1, boolean var2);
    }
}

