/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByAndroidViewTag;
import io.appium.java_client.HasOnScreenKeyboard;
import io.appium.java_client.LocksDevice;
import io.appium.java_client.android.AndroidBatteryInfo;
import io.appium.java_client.android.AndroidMobileCommandHelper;
import io.appium.java_client.android.AuthenticatesByFinger;
import io.appium.java_client.android.HasAndroidClipboard;
import io.appium.java_client.android.HasAndroidDeviceDetails;
import io.appium.java_client.android.HasAndroidSettings;
import io.appium.java_client.android.HasSupportedPerformanceDataType;
import io.appium.java_client.android.ListensToLogcatMessages;
import io.appium.java_client.android.PushesFiles;
import io.appium.java_client.android.StartsActivity;
import io.appium.java_client.android.SupportsNetworkStateManagement;
import io.appium.java_client.android.SupportsSpecialEmulatorCommands;
import io.appium.java_client.android.connection.HasNetworkConnection;
import io.appium.java_client.android.nativekey.PressesKey;
import io.appium.java_client.battery.HasBattery;
import io.appium.java_client.screenrecording.CanRecordScreen;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.http.HttpClient;

public class AndroidDriver<T extends WebElement>
extends AppiumDriver<T>
implements PressesKey,
HasNetworkConnection,
PushesFiles,
StartsActivity,
FindsByAndroidUIAutomator<T>,
FindsByAndroidViewTag<T>,
LocksDevice,
HasAndroidSettings,
HasAndroidDeviceDetails,
HasSupportedPerformanceDataType,
AuthenticatesByFinger,
HasOnScreenKeyboard,
CanRecordScreen,
SupportsSpecialEmulatorCommands,
SupportsNetworkStateManagement,
ListensToLogcatMessages,
HasAndroidClipboard,
HasBattery<AndroidBatteryInfo> {
    private static final String ANDROID_PLATFORM = "Android";
    private StringWebSocketClient logcatClient;

    public AndroidDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, AndroidDriver.substituteMobilePlatform(capabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public AndroidDriver(Capabilities desiredCapabilities) {
        super(AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM));
    }

    public void endTestCoverage(String intent, String path) {
        CommandExecutionHelper.execute((ExecutesMethod)this, AndroidMobileCommandHelper.endTestCoverageCommand(intent, path));
    }

    public void openNotifications() {
        CommandExecutionHelper.execute((ExecutesMethod)this, AndroidMobileCommandHelper.openNotificationsCommand());
    }

    public void toggleLocationServices() {
        CommandExecutionHelper.execute((ExecutesMethod)this, AndroidMobileCommandHelper.toggleLocationServicesCommand());
    }

    @Override
    public AndroidBatteryInfo getBatteryInfo() {
        return new AndroidBatteryInfo((Map)this.execute("executeScript", (Map)ImmutableMap.of((Object)"script", (Object)"mobile: batteryInfo", (Object)"args", Collections.emptyList())).getValue());
    }

    public Capabilities getCapabilities() {
        MutableCapabilities capabilities = (MutableCapabilities)super.getCapabilities();
        capabilities.setCapability("platformName", ANDROID_PLATFORM);
        return capabilities;
    }

    @Override
    public synchronized StringWebSocketClient getLogcatClient() {
        if (this.logcatClient == null) {
            this.logcatClient = new StringWebSocketClient();
        }
        return this.logcatClient;
    }
}

