/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ws;

import io.appium.java_client.ws.CanHandleConnects;
import io.appium.java_client.ws.CanHandleDisconnects;
import io.appium.java_client.ws.CanHandleErrors;
import io.appium.java_client.ws.CanHandleMessages;
import io.appium.java_client.ws.WebSocketClient;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.openqa.selenium.WebDriverException;

@ClientEndpoint
public class StringWebSocketClient
extends WebSocketClient
implements CanHandleMessages<String>,
CanHandleErrors,
CanHandleConnects,
CanHandleDisconnects {
    private final List<Consumer<String>> messageHandlers = new CopyOnWriteArrayList<Consumer<String>>();
    private final List<Consumer<Throwable>> errorHandlers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> connectHandlers = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectHandlers = new CopyOnWriteArrayList<Runnable>();
    private volatile Session session;

    @Override
    public void connect(URI endpoint) {
        if (this.session != null) {
            if (endpoint.equals(this.getEndpoint())) {
                return;
            }
            this.removeAllHandlers();
            try {
                this.session.close();
            }
            catch (IOException iOException) {}
            this.session = null;
        }
        super.connect(endpoint);
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        this.getConnectionHandlers().forEach(Runnable::run);
    }

    @OnClose
    public void onClose() {
        this.session = null;
        this.getDisconnectionHandlers().forEach(Runnable::run);
    }

    @OnError
    public void onError(Throwable cause) {
        this.session = null;
        this.getErrorHandlers().forEach(x -> x.accept(cause));
        throw new WebDriverException(cause);
    }

    @OnMessage
    public void onMessage(String message) {
        this.getMessageHandlers().forEach(x -> x.accept(message));
    }

    @Override
    public List<Consumer<String>> getMessageHandlers() {
        return this.messageHandlers;
    }

    @Override
    public List<Consumer<Throwable>> getErrorHandlers() {
        return this.errorHandlers;
    }

    @Override
    public List<Runnable> getConnectionHandlers() {
        return this.connectHandlers;
    }

    @Override
    public List<Runnable> getDisconnectionHandlers() {
        return this.disconnectHandlers;
    }

    public void removeAllHandlers() {
        this.removeMessageHandlers();
        this.removeErrorHandlers();
        this.removeConnectionHandlers();
        this.removeDisconnectionHandlers();
    }
}

