/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.base.Function;
import io.appium.java_client.pagefactory.AppiumAnnotations;
import io.appium.java_client.pagefactory.TimeOutContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements ElementLocator {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;
    private final TimeOutContainer timeOutContainer;

    AppiumElementLocator(SearchContext searchContext, Field field, TimeOutContainer timeOutContainer) {
        this.searchContext = searchContext;
        String platform = String.valueOf(((HasCapabilities)this.unpackWebDriverFromSearchContext()).getCapabilities().getCapability("platformName"));
        AppiumAnnotations annotations = new AppiumAnnotations(field, platform);
        this.timeOutContainer = timeOutContainer;
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    private WebDriver unpackWebDriverFromSearchContext() {
        WebDriver driver = null;
        if (this.searchContext instanceof WebDriver) {
            driver = (WebDriver)this.searchContext;
        }
        if (this.searchContext instanceof WebElement) {
            WebElement element = (WebElement)this.searchContext;
            while (element instanceof WrapsElement) {
                element = ((WrapsElement)element).getWrappedElement();
            }
            driver = ((WrapsDriver)element).getWrappedDriver();
        }
        return driver;
    }

    private void changeImplicitlyWaitTimeOut(long newTimeOut, TimeUnit newTimeUnit) {
        this.unpackWebDriverFromSearchContext().manage().timeouts().implicitlyWait(newTimeOut, newTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WebElement> waitFor() {
        try {
            this.changeImplicitlyWaitTimeOut(0L, TimeUnit.SECONDS);
            FluentWait wait = new FluentWait((Object)this.by);
            wait.withTimeout(this.timeOutContainer.getTimeValue(), this.timeOutContainer.getTimeUnitValue());
            List list = (List)wait.until((Function)new WaitingFunction(this.searchContext));
            return list;
        }
        catch (TimeoutException e) {
            ArrayList<WebElement> arrayList = new ArrayList<WebElement>();
            return arrayList;
        }
        finally {
            this.changeImplicitlyWaitTimeOut(this.timeOutContainer.getTimeValue(), this.timeOutContainer.getTimeUnitValue());
        }
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        List<WebElement> result = this.waitFor();
        if (result.size() == 0) {
            String message = "Cann't locate an element by this strategy: " + this.by.toString();
            throw new NoSuchElementException(message);
        }
        if (this.shouldCache) {
            this.cachedElement = result.get(0);
        }
        return result.get(0);
    }

    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List<WebElement> result = this.waitFor();
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    private static class WaitingFunction
    implements Function<By, List<WebElement>> {
        private final SearchContext searchContext;

        private WaitingFunction(SearchContext searchContext) {
            this.searchContext = searchContext;
        }

        public List<WebElement> apply(By by) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            try {
                result.addAll(this.searchContext.findElements(by));
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                // empty catch block
            }
            if (result.size() > 0) {
                return result;
            }
            return null;
        }
    }
}

