/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.config;

import io.apicurio.registry.resolver.SchemaResolverConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DefaultSchemaResolverConfig {
    private static final Map<String, Object> DEFAULTS = Map.ofEntries(Map.entry("apicurio.registry.artifact-resolver-strategy", SchemaResolverConfig.ARTIFACT_RESOLVER_STRATEGY_DEFAULT), Map.entry("apicurio.registry.auto-register", false), Map.entry("apicurio.registry.auto-register.if-exists", SchemaResolverConfig.AUTO_REGISTER_ARTIFACT_IF_EXISTS_DEFAULT), Map.entry("apicurio.registry.cache-latest", true), Map.entry("apicurio.registry.fault-tolerant-refresh", false), Map.entry("apicurio.registry.find-latest", false), Map.entry("apicurio.registry.check-period-ms", 30000L), Map.entry("apicurio.registry.retry-count", 3L), Map.entry("apicurio.registry.retry-backoff-ms", 300L), Map.entry("apicurio.registry.dereference-schema", true), Map.entry("apicurio.registry.deserializer.dereference-schema", false), Map.entry("apicurio.registry.serializer.dereference-schema", false));
    private Map<String, ?> originals;

    public DefaultSchemaResolverConfig(Map<String, ?> originals) {
        this.originals = originals;
    }

    public String getRegistryUrl() {
        return this.getString("apicurio.registry.url");
    }

    public String getTokenEndpoint() {
        return this.getString("apicurio.auth.service.token.endpoint");
    }

    public String getAuthServiceUrl() {
        return this.getString("apicurio.auth.service.url");
    }

    public String getAuthRealm() {
        return this.getString("apicurio.auth.realm");
    }

    public String getAuthClientId() {
        return this.getString("apicurio.auth.client.id");
    }

    public String getAuthClientSecret() {
        return this.getString("apicurio.auth.client.secret");
    }

    public String getAuthClientScope() {
        return this.getString("apicurio.auth.client.scope");
    }

    public String getAuthUsername() {
        return this.getString("apicurio.auth.username");
    }

    public String getAuthPassword() {
        return this.getString("apicurio.auth.password");
    }

    public Object getArtifactResolverStrategy() {
        return this.getObject("apicurio.registry.artifact-resolver-strategy");
    }

    public boolean autoRegisterArtifact() {
        return this.getBoolean("apicurio.registry.auto-register");
    }

    public String autoRegisterArtifactIfExists() {
        return this.getStringOneOf("apicurio.registry.auto-register.if-exists", "FAIL", "UPDATE", "RETURN", "RETURN_OR_UPDATE");
    }

    public boolean getCacheLatest() {
        return this.getBoolean("apicurio.registry.cache-latest");
    }

    public boolean getFaultTolerantRefresh() {
        return this.getBoolean("apicurio.registry.fault-tolerant-refresh");
    }

    public boolean findLatest() {
        return this.getBoolean("apicurio.registry.find-latest");
    }

    public Duration getCheckPeriod() {
        return this.getDurationNonNegativeMillis("apicurio.registry.check-period-ms");
    }

    public long getRetryCount() {
        return this.getLongNonNegative("apicurio.registry.retry-count");
    }

    public Duration getRetryBackoff() {
        return this.getDurationNonNegativeMillis("apicurio.registry.retry-backoff-ms");
    }

    public String getExplicitArtifactGroupId() {
        return this.getString("apicurio.registry.artifact.group-id");
    }

    public String getExplicitArtifactId() {
        return this.getString("apicurio.registry.artifact.artifact-id");
    }

    public String getExplicitSchemaLocation() {
        return this.getString("apicurio.registry.artifact.schema.location");
    }

    public String getExplicitArtifactVersion() {
        return this.getString("apicurio.registry.artifact.version");
    }

    public Map<String, Object> originals() {
        return new HashMap<String, Object>(this.originals);
    }

    Object getObject(String key) {
        if (key == null) {
            throw new NullPointerException("Configuration property key is null.");
        }
        if (!this.originals.containsKey(key) && DEFAULTS.containsKey(key)) {
            return DEFAULTS.get(key);
        }
        return this.originals.get(key);
    }

    public boolean registerDereferenced() {
        return this.getBooleanOrFalse("apicurio.registry.dereference-schema");
    }

    public boolean deserializerDereference() {
        return this.getBooleanOrFalse("apicurio.registry.deserializer.dereference-schema");
    }

    public boolean serializerDereference() {
        return this.getBooleanOrFalse("apicurio.registry.serializer.dereference-schema");
    }

    private Duration getDurationNonNegativeMillis(String key) {
        long millis;
        Object value = this.getObject(key);
        if (value == null) {
            this.reportError(key, "a non-null value", value);
        }
        if (value instanceof Number) {
            millis = ((Number)value).longValue();
        } else if (value instanceof String) {
            millis = Long.parseLong((String)value);
        } else if (value instanceof Duration) {
            millis = ((Duration)value).toMillis();
        } else {
            this.reportError(key, "a duration-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        if (millis < 0L) {
            this.reportError(key, "a non-negative duration-like value", value);
        }
        return Duration.ofMillis(millis);
    }

    private long getLongNonNegative(String key) {
        long result;
        Object value = this.getObject(key);
        if (value == null) {
            this.reportError(key, "a non-null value", value);
        }
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            result = Long.parseLong((String)value);
        } else {
            this.reportError(key, "a number-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        if (result < 0L) {
            this.reportError(key, "a non-negative number-like value", value);
        }
        return result;
    }

    private String getString(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ((String)value).trim();
        }
        this.reportError(key, "a String", value.getClass().getName());
        throw new IllegalStateException("Unreachable");
    }

    private String getStringOneOf(String key, String ... possibilities) {
        String result = this.getString(key);
        if (!Arrays.asList(possibilities).contains(result)) {
            this.reportError(key, "one of " + Arrays.toString(possibilities), result);
        }
        return result;
    }

    private Boolean getBooleanOrFalse(String key) {
        Boolean val = this.getBoolean(key);
        return val != null && val != false;
    }

    private Boolean getBoolean(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            String trimmed = ((String)value).trim();
            if (trimmed.equalsIgnoreCase("true")) {
                return true;
            }
            if (trimmed.equalsIgnoreCase("false")) {
                return false;
            }
            this.reportError(key, "a boolean-like value", value);
            throw new IllegalStateException("Unreachable");
        }
        this.reportError(key, "a boolean-like value", value);
        throw new IllegalStateException("Unreachable");
    }

    private void reportError(String key, String expectedText, Object value) {
        throw new IllegalArgumentException("Invalid configuration property value for '" + key + "'. Expected " + expectedText + ", but got a '" + String.valueOf(value) + "'.");
    }
}

