/*
 * Decompiled with CFR 0.152.
 */
package info.solidsoft.gradle.pitest.internal;

import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import info.solidsoft.gradle.pitest.PitestPlugin;
import info.solidsoft.gradle.pitest.internal.GradleUtil;
import java.beans.Transient;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class GradleVersionEnforcer
implements GroovyObject {
    private static final String DISABLE_GRADLE_VERSION_ENFORCEMENT_PROPERTY_NAME = "gpp.disableGradleVersionEnforcement";
    private final GradleVersion minimalSupportedVersion;
    private final String propertyNameToDisable;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private GradleVersionEnforcer(GradleVersion minimalSupportedVersion, String propertyNameToDisable) {
        String string;
        GradleVersion gradleVersion;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.minimalSupportedVersion = gradleVersion = minimalSupportedVersion;
        this.propertyNameToDisable = string = propertyNameToDisable;
    }

    public static GradleVersionEnforcer defaultEnforcer(GradleVersion minimalSupportedVersion) {
        return new GradleVersionEnforcer(minimalSupportedVersion, DISABLE_GRADLE_VERSION_ENFORCEMENT_PROPERTY_NAME);
    }

    public void failBuildWithMeaningfulErrorIfAppliedOnTooOldGradleVersion(Project project) {
        if (ScriptBytecodeAdapter.compareLessThan((Object)GradleVersion.current(), (Object)this.minimalSupportedVersion)) {
            Object v0;
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{PitestPlugin.PLUGIN_ID, this.minimalSupportedVersion.getVersion()}, new String[]{"WARNING. The '", "' plugin requires ", " to run properly "}).plus((GString)new GStringImpl(new Object[]{GradleVersion.current()}, new String[]{"(detected: ", "). Please upgrade your Gradle or downgrade the plugin version."}))));
                v0 = null;
            } else {
                v0 = null;
            }
            if (GradleUtil.isPropertyNotDefinedOrFalse(project, this.propertyNameToDisable)) {
                Object v1;
                if (log.isWarnEnabled()) {
                    log.warn(StringGroovyMethods.plus((String)"Aborting the build with the meaningful error message to prevent confusion. If you are sure it is an error, ", (CharSequence)new GStringImpl(new Object[]{this.propertyNameToDisable}, new String[]{"please report it in the plugin issue tracker and in the meantime use '-P", "' to disable this check"})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{PitestPlugin.PLUGIN_ID, this.minimalSupportedVersion.getVersion()}, new String[]{"'", "' requires Gradle ", ""})));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GradleVersionEnforcer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"info.solidsoft.gradle.pitest.internal.GradleVersionEnforcer");
    }
}

