/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi.tools;

import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApiUrl {
    private static final String TMDB_API_BASE = "https://api.themoviedb.org/3/";
    private static final String APPEND_TO_RESPONSE = "append_to_response";
    private final String baseUrl;
    private final Map<String, String> params = new HashMap<String, String>();

    public ApiUrl(Object ... urlElements) {
        StringBuilder baseUrlBuilder = new StringBuilder(TMDB_API_BASE);
        for (int i = 0; i < urlElements.length; ++i) {
            baseUrlBuilder.append(urlElements[i]);
            if (i >= urlElements.length - 1) continue;
            baseUrlBuilder.append("/");
        }
        this.baseUrl = baseUrlBuilder.toString();
    }

    public URL buildUrl() {
        StringBuilder urlBuilder = new StringBuilder(this.baseUrl);
        try {
            if (this.params.size() > 0) {
                ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
                for (int i = 0; i < keys.size(); ++i) {
                    urlBuilder.append(i == 0 ? "?" : "&");
                    String paramName = (String)keys.get(i);
                    urlBuilder.append(paramName).append("=");
                    urlBuilder.append(URLEncoder.encode(this.params.get(paramName), "UTF-8"));
                }
            }
            return new URL(urlBuilder.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void addParam(String name, Object value) {
        this.addParam(name, value.toString());
    }

    public void addParam(String name, String value) {
        if (this.params.containsKey(name)) {
            throw new RuntimeException("paramater '" + name + "' already defined");
        }
        if ((name = StringUtils.trimToEmpty((String)name)).isEmpty()) {
            throw new RuntimeException("parameter name can not be empty");
        }
        if ((value = StringUtils.trimToEmpty((String)value)).isEmpty()) {
            throw new RuntimeException("value of parameter '" + name + "' can not be empty");
        }
        this.params.put(name, value);
    }

    public void addParam(String key, int value) {
        this.addParam(key, Integer.toString(value));
    }

    public void addParam(String key, boolean value) {
        this.addParam(key, Boolean.toString(value));
    }

    public void appendToResponse(String ... appendToResponse) {
        if (appendToResponse == null || appendToResponse.length == 0) {
            return;
        }
        this.addParam(APPEND_TO_RESPONSE, StringUtils.join((Object[])appendToResponse, (String)","));
    }

    public void addPage(Integer page) {
        if (page != null && page > 0) {
            this.addParam("page", page);
        }
    }

    public void addLanguage(String language) {
        if (StringUtils.isNotBlank((CharSequence)language)) {
            this.addParam("language", language);
        }
    }
}

