/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.MovieDb;
import info.movito.themoviedbapi.model.config.TmdbConfiguration;
import info.movito.themoviedbapi.tools.MovieDbException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static boolean compareMovies(MovieDb moviedb, String title, String year) {
        return Utils.compareMovies(moviedb, title, year, 0);
    }

    public static boolean compareMovies(MovieDb moviedb, String title, String year, int maxDistance) {
        String movieYear;
        if (moviedb == null || StringUtils.isBlank((CharSequence)title)) {
            return Boolean.FALSE;
        }
        if (Utils.isValidYear(year) && Utils.isValidYear(moviedb.getReleaseDate()) && (movieYear = moviedb.getReleaseDate().substring(0, 4)).equals(year)) {
            if (Utils.compareDistance(moviedb.getOriginalTitle(), title, maxDistance)) {
                return Boolean.TRUE;
            }
            if (Utils.compareDistance(moviedb.getTitle(), title, maxDistance)) {
                return Boolean.TRUE;
            }
        }
        if (Utils.compareDistance(moviedb.getOriginalTitle(), title, maxDistance)) {
            return Boolean.TRUE;
        }
        if (Utils.compareDistance(moviedb.getTitle(), title, maxDistance)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean compareDistance(String title1, String title2, int distance) {
        return StringUtils.getLevenshteinDistance((CharSequence)title1, (CharSequence)title2) <= distance;
    }

    private static boolean isValidYear(String year) {
        return StringUtils.isNotBlank((CharSequence)year) && !year.equals("UNKNOWN");
    }

    static void sleep(int timeMs) {
        try {
            Thread.sleep(timeMs);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL createImageUrl(TmdbApi tmdb, String imagePath, String requiredSize) {
        if (StringUtils.isBlank((CharSequence)imagePath)) {
            return null;
        }
        TmdbConfiguration configuration = tmdb.getConfiguration();
        if (!configuration.isValidSize(requiredSize)) {
            throw new MovieDbException("Invalid size: " + requiredSize);
        }
        StringBuilder sb = new StringBuilder(configuration.getBaseUrl());
        sb.append(requiredSize);
        sb.append(imagePath);
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            throw new MovieDbException(sb.toString(), ex);
        }
    }

    public static <T> List<T> nullAsEmpty(List<T> items) {
        return items == null ? new ArrayList() : items;
    }

    public static String convertToJson(ObjectMapper jsonMapper, Map<String, ?> map) {
        try {
            return new ObjectMapper().writeValueAsString(map);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException("json conversion failed", jpe);
        }
    }

    public static <T> List<T> copyIterator(Iterator<T> iter) {
        ArrayList<T> copy = new ArrayList<T>();
        while (iter.hasNext()) {
            copy.add(iter.next());
        }
        return copy;
    }

    public static String[] asStringArray(Object[] appendToResponse) {
        if (appendToResponse == null || appendToResponse.length == 0) {
            return null;
        }
        String[] asArray = new String[appendToResponse.length];
        for (int i = 0; i < appendToResponse.length; ++i) {
            asArray[i] = appendToResponse[i].toString();
        }
        return asArray;
    }

    public static Integer parseInteger(String valueOrNull) {
        return valueOrNull == null ? null : Integer.valueOf(Integer.parseInt(valueOrNull));
    }
}

