/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbAccount;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.TmdbPeople;
import info.movito.themoviedbapi.TvResultsPage;
import info.movito.themoviedbapi.model.Collection;
import info.movito.themoviedbapi.model.Company;
import info.movito.themoviedbapi.model.Multi;
import info.movito.themoviedbapi.model.core.MovieResultsPage;
import info.movito.themoviedbapi.model.core.ResultsPage;
import info.movito.themoviedbapi.model.keywords.Keyword;
import info.movito.themoviedbapi.tools.ApiUrl;
import org.apache.commons.lang3.StringUtils;

public class TmdbSearch
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_SEARCH = "search";
    private static final String PARAM_QUERY = "query";
    public static final Object TMDB_METHOD_MULTI = "multi";

    public TmdbSearch(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MovieResultsPage searchMovie(String query, Integer searchYear, String language, boolean includeAdult, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "movie");
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new RuntimeException("query must not be blank");
        }
        apiUrl.addParam(PARAM_QUERY, query);
        if (searchYear != null && searchYear > 0) {
            apiUrl.addParam("year", Integer.toString(searchYear));
        }
        apiUrl.addLanguage(language);
        apiUrl.addParam("include_adult", Boolean.toString(includeAdult));
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MovieResultsPage.class);
    }

    public TvResultsPage searchTv(String query, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "tv");
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new RuntimeException("query must not be blank");
        }
        apiUrl.addParam(PARAM_QUERY, query);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TvResultsPage.class);
    }

    public CollectionResultsPage searchCollection(String query, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "collection");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addParam(PARAM_QUERY, query);
        }
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, CollectionResultsPage.class);
    }

    public TmdbPeople.PersonResultsPage searchPerson(String query, boolean includeAdult, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "person");
        apiUrl.addParam(PARAM_QUERY, query);
        apiUrl.addParam("include_adult", includeAdult);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TmdbPeople.PersonResultsPage.class);
    }

    public TmdbAccount.MovieListResultsPage searchList(String query, String language, Integer page) {
        System.err.println("This method is part of the API but seems currently not available. See https://www.themoviedb.org/talk/593409e3c3a36859ef01eddb#597124f8c3a3681608008424");
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "list");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addParam(PARAM_QUERY, query);
        }
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, TmdbAccount.MovieListResultsPage.class);
    }

    public CompanyResultsPage searchCompany(String companyName, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "company");
        apiUrl.addParam(PARAM_QUERY, companyName);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, CompanyResultsPage.class);
    }

    public KeywordResultsPage searchKeyword(String query, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, "keyword");
        if (StringUtils.isNotBlank((CharSequence)query)) {
            apiUrl.addParam(PARAM_QUERY, query);
        }
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, KeywordResultsPage.class);
    }

    public MultiListResultsPage searchMulti(String query, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_SEARCH, TMDB_METHOD_MULTI);
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new RuntimeException("query must not be blank");
        }
        apiUrl.addParam(PARAM_QUERY, query);
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, MultiListResultsPage.class);
    }

    public static class MultiListResultsPage
    extends ResultsPage<Multi> {
    }

    public static class CollectionResultsPage
    extends ResultsPage<Collection> {
    }

    public static class CompanyResultsPage
    extends ResultsPage<Company> {
    }

    public static class KeywordResultsPage
    extends ResultsPage<Keyword> {
    }
}

