/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.Utils;
import info.movito.themoviedbapi.model.ListItemStatus;
import info.movito.themoviedbapi.model.MovieList;
import info.movito.themoviedbapi.model.MovieListCreationStatus;
import info.movito.themoviedbapi.model.core.ResponseStatus;
import info.movito.themoviedbapi.model.core.SessionToken;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.RequestMethod;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class TmdbLists
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_LIST = "list";

    public TmdbLists(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public MovieList getList(String listId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId);
        return this.mapJsonResult(apiUrl, MovieList.class);
    }

    public String createList(SessionToken sessionToken, String name, String description) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST);
        apiUrl.addParam("session_id", sessionToken);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("name", StringUtils.trimToEmpty((String)name));
        body.put("description", StringUtils.trimToEmpty((String)description));
        String jsonBody = Utils.convertToJson(jsonMapper, body);
        return this.mapJsonResult(apiUrl, MovieListCreationStatus.class, jsonBody).getListId();
    }

    public boolean isMovieOnList(String listId, Integer movieId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, "item_status");
        apiUrl.addParam("movie_id", movieId);
        return this.mapJsonResult(apiUrl, ListItemStatus.class).isItemPresent();
    }

    public ResponseStatus addMovieToList(SessionToken sessionToken, String listId, Integer movieId) {
        return this.modifyMovieList(sessionToken, listId, movieId, "add_item");
    }

    public ResponseStatus removeMovieFromList(SessionToken sessionToken, String listId, Integer movieId) {
        return this.modifyMovieList(sessionToken, listId, movieId, "remove_item");
    }

    private ResponseStatus modifyMovieList(SessionToken sessionToken, String listId, Integer movieId, String operation) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId, operation);
        apiUrl.addParam("session_id", sessionToken);
        String jsonBody = Utils.convertToJson(jsonMapper, Collections.singletonMap("media_id", movieId + ""));
        return this.mapJsonResult(apiUrl, ResponseStatus.class, jsonBody);
    }

    public ResponseStatus deleteMovieList(SessionToken sessionToken, String listId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_LIST, listId);
        apiUrl.addParam("session_id", sessionToken);
        return this.mapJsonResult(apiUrl, ResponseStatus.class, null, RequestMethod.DELETE);
    }
}

