/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.Collection;
import info.movito.themoviedbapi.model.Company;
import info.movito.themoviedbapi.model.core.ResultsPage;
import info.movito.themoviedbapi.tools.ApiUrl;

public class TmdbCompany
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_COMPANY = "company";

    TmdbCompany(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public Company getCompanyInfo(int companyId) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COMPANY, companyId);
        return this.mapJsonResult(apiUrl, Company.class);
    }

    public CollectionResultsPage getCompanyMovies(int companyId, String language, Integer page) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COMPANY, companyId, "movies");
        apiUrl.addLanguage(language);
        apiUrl.addPage(page);
        return this.mapJsonResult(apiUrl, CollectionResultsPage.class);
    }

    public static class CollectionResultsPage
    extends ResultsPage<Collection> {
    }
}

