/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import info.movito.themoviedbapi.AbstractTmdbApi;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.Artwork;
import info.movito.themoviedbapi.model.ArtworkType;
import info.movito.themoviedbapi.model.CollectionInfo;
import info.movito.themoviedbapi.model.MovieImages;
import info.movito.themoviedbapi.tools.ApiUrl;
import java.util.List;

public class TmdbCollections
extends AbstractTmdbApi {
    public static final String TMDB_METHOD_COLLECTION = "collection";

    TmdbCollections(TmdbApi tmdbApi) {
        super(tmdbApi);
    }

    public CollectionInfo getCollectionInfo(int collectionId, String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COLLECTION, collectionId);
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, CollectionInfo.class);
    }

    public List<Artwork> getCollectionImages(int collectionId, String language) {
        ApiUrl apiUrl = new ApiUrl(TMDB_METHOD_COLLECTION, collectionId, "images");
        apiUrl.addLanguage(language);
        return this.mapJsonResult(apiUrl, MovieImages.class).getAll(ArtworkType.POSTER, ArtworkType.BACKDROP);
    }
}

