/*
 * Decompiled with CFR 0.152.
 */
package info.movito.themoviedbapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.movito.themoviedbapi.TmdbApi;
import info.movito.themoviedbapi.model.core.ResponseStatus;
import info.movito.themoviedbapi.model.core.ResponseStatusException;
import info.movito.themoviedbapi.tools.ApiUrl;
import info.movito.themoviedbapi.tools.MovieDbException;
import info.movito.themoviedbapi.tools.RequestMethod;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTmdbApi {
    public static final String PARAM_YEAR = "year";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_LANGUAGE = "language";
    public static final String PARAM_ID = "id";
    public static final String PARAM_ADULT = "include_adult";
    public static final String PARAM_API_KEY = "api_key";
    protected static final ObjectMapper jsonMapper = new ObjectMapper();
    protected final TmdbApi tmdbApi;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Collection<Integer> SUCCESS_STATUS_CODES = Arrays.asList(1, 12, 13);

    AbstractTmdbApi(TmdbApi tmdbApi) {
        this.tmdbApi = tmdbApi;
    }

    public <T> T mapJsonResult(ApiUrl apiUrl, Class<T> someClass) {
        return this.mapJsonResult(apiUrl, someClass, null);
    }

    public <T> T mapJsonResult(ApiUrl apiUrl, Class<T> someClass, String jsonBody) {
        return this.mapJsonResult(apiUrl, someClass, jsonBody, RequestMethod.GET);
    }

    public <T> T mapJsonResult(ApiUrl apiUrl, Class<T> someClass, String jsonBody, RequestMethod requestMethod) {
        String webpage = this.tmdbApi.requestWebPage(apiUrl, jsonBody, requestMethod);
        try {
            Integer statusCode;
            ResponseStatus responseStatus = (ResponseStatus)jsonMapper.readValue(webpage, ResponseStatus.class);
            String suspectedSpam = "Unable to create list because: Description is suspected to be spam.";
            if (webpage.contains(suspectedSpam)) {
                responseStatus = new ResponseStatus(-100, suspectedSpam);
            }
            if ((statusCode = responseStatus.getStatusCode()) != null && !SUCCESS_STATUS_CODES.contains(statusCode)) {
                throw new ResponseStatusException(responseStatus);
            }
            return (T)jsonMapper.readValue(webpage, someClass);
        }
        catch (IOException ex) {
            throw new MovieDbException("mapping failed:\n" + webpage);
        }
    }
}

