/*
 * Decompiled with CFR 0.152.
 */
package info.kimjihyok.ripplelibrary.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import info.kimjihyok.ripplelibrary.renderer.CircleRippleRenderer;

public class TimerCircleRippleRenderer
extends CircleRippleRenderer {
    private static final String TAG = "TimerCircleRippleRenderer";
    private int strokeWidth;
    private Paint timerPaint;
    private Paint timerBackgroundPaint;
    private RectF rect;
    private double maxTimeMilliseconds;
    private double currentTimeMilliseconds;
    private TimerRendererListener listener;

    public TimerCircleRippleRenderer(Paint ripplePaint, Paint rippleBackgroundPaint, Paint buttonPaint, Paint timerPaint, double maxTimeMilliseconds, double currentTimeMilliseconds) {
        super(ripplePaint, rippleBackgroundPaint, buttonPaint);
        this.timerPaint = timerPaint;
        this.maxTimeMilliseconds = maxTimeMilliseconds;
        this.currentTimeMilliseconds = currentTimeMilliseconds;
        this.init();
    }

    public void setTimerRendererListener(TimerRendererListener listener) {
        this.listener = listener;
    }

    private void init() {
        this.rect = new RectF();
        this.timerBackgroundPaint = new Paint();
        this.timerBackgroundPaint.setColor(Color.parseColor((String)"#EEEEEE"));
        this.timerBackgroundPaint.setStrokeWidth(20.0f);
        this.timerBackgroundPaint.setAntiAlias(true);
        this.timerBackgroundPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.timerBackgroundPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void render(Canvas canvas, int x, int y, int buttonRadius, int rippleRadius, int rippleBackgroundRadius) {
        super.render(canvas, x, y, buttonRadius, rippleRadius, rippleBackgroundRadius);
        this.rect.set((float)(x - buttonRadius + this.strokeWidth / 2), (float)(y - buttonRadius + this.strokeWidth / 2), (float)(x + buttonRadius - this.strokeWidth / 2), (float)(y + buttonRadius - this.strokeWidth / 2));
        canvas.drawArc(this.rect, -90.0f, 360.0f, false, this.timerBackgroundPaint);
        canvas.drawArc(this.rect, -90.0f, (float)(360.0 * (this.currentTimeMilliseconds / this.maxTimeMilliseconds)), false, this.timerPaint);
        if (this.currentTimeMilliseconds >= this.maxTimeMilliseconds) {
            this.listener.stopRecording();
        }
    }

    @Override
    public void changeColor(@ColorInt int color) {
        super.changeColor(color);
    }

    public void setCurrentTimeMilliseconds(int currentTimeMilliseconds) {
        this.currentTimeMilliseconds = currentTimeMilliseconds;
    }

    public void setStrokeWidth(int strokeWidth) {
        if (strokeWidth % 2 != 0) {
            throw new IllegalArgumentException("Stroke Width should be an even number!");
        }
        this.strokeWidth = strokeWidth;
        this.timerPaint.setStrokeWidth((float)strokeWidth);
    }

    public static interface TimerRendererListener {
        public void stopRecording();

        public void startRecording();
    }
}

