/*
 * Decompiled with CFR 0.152.
 */
package info.kimjihyok.ripplelibrary.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import info.kimjihyok.ripplelibrary.renderer.Renderer;

public class CircleRippleRenderer
extends Renderer {
    private Paint buttonPaint;
    private Paint ripplePaint;
    private Paint rippleBackgroundPaint;

    public CircleRippleRenderer(Paint ripplePaint, Paint rippleBackgroundPaint, Paint buttonPaint) {
        this.ripplePaint = ripplePaint;
        this.rippleBackgroundPaint = rippleBackgroundPaint;
        this.buttonPaint = buttonPaint;
    }

    @Override
    public void render(Canvas canvas, int x, int y, int buttonRadius, int rippleRadius, int rippleBackgroundRadius) {
        super.render(canvas, x, y, buttonRadius, rippleRadius, rippleBackgroundRadius);
        canvas.drawCircle((float)x, (float)y, (float)rippleRadius, this.ripplePaint);
        canvas.drawCircle((float)x, (float)y, (float)rippleBackgroundRadius, this.rippleBackgroundPaint);
        canvas.drawCircle((float)x, (float)y, (float)buttonRadius, this.buttonPaint);
    }

    @Override
    public void changeColor(@ColorInt int color) {
        this.ripplePaint.setColor(color);
        this.rippleBackgroundPaint.setColor(color & 0xFFFFFF | 0x40000000);
    }
}

