/*
 * Decompiled with CFR 0.152.
 */
package info.kimjihyok.ripplelibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.media.MediaRecorder;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import info.kimjihyok.ripplelibrary.R;
import info.kimjihyok.ripplelibrary.Rate;
import info.kimjihyok.ripplelibrary.listener.RecordingListener;
import info.kimjihyok.ripplelibrary.renderer.Renderer;
import info.kimjihyok.ripplelibrary.renderer.TimerCircleRippleRenderer;
import java.io.IOException;

public class VoiceRippleView
extends View
implements TimerCircleRippleRenderer.TimerRendererListener {
    private static final String TAG = "VoiceRippleView";
    private static final double AMPLITUDE_REFERENCE = 32767.0;
    private static int MIN_RADIUS;
    private static int MIN_ICON_SIZE;
    private static int MIN_FIRST_RIPPLE_RADIUS;
    private static final int INVALID_PARAMETER = -1;
    private int buttonRadius;
    private int rippleRadius;
    private int backgroundRadius;
    private int iconSize;
    private boolean isRecording;
    private boolean isPrepared;
    private int rippleDecayRate = -1;
    private int thresholdRate = -1;
    private double backgroundRippleRatio = -1.0;
    private int audioSource = -1;
    private int outputFormat = -1;
    private int audioEncoder = -1;
    private MediaRecorder recorder;
    private Drawable recordIcon;
    private Drawable recordingIcon;
    private View.OnClickListener listener;
    private Handler handler;
    private RecordingListener recordingListener;
    private Renderer currentRenderer;
    private int currentRecordedTime = 0;
    private int minFirstRadius;
    private Runnable updateRipple = new Runnable(){

        @Override
        public void run() {
            if (VoiceRippleView.this.isRecording) {
                VoiceRippleView.this.drop(VoiceRippleView.this.recorder.getMaxAmplitude());
                VoiceRippleView.this.currentRecordedTime = VoiceRippleView.this.currentRecordedTime + 50;
                if (VoiceRippleView.this.currentRenderer instanceof TimerCircleRippleRenderer) {
                    ((TimerCircleRippleRenderer)VoiceRippleView.this.currentRenderer).setCurrentTimeMilliseconds(VoiceRippleView.this.currentRecordedTime);
                }
                VoiceRippleView.this.handler.postDelayed((Runnable)this, 50L);
            }
        }
    };

    public void setRenderer(Renderer currentRenderer) {
        this.currentRenderer = currentRenderer;
        if (currentRenderer instanceof TimerCircleRippleRenderer) {
            ((TimerCircleRippleRenderer)currentRenderer).setTimerRendererListener(this);
        }
        this.invalidate();
    }

    public VoiceRippleView(Context context) {
        super(context);
        this.init(context, null);
    }

    public VoiceRippleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public VoiceRippleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        MIN_RADIUS = (int)TypedValue.applyDimension((int)1, (float)50.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        MIN_ICON_SIZE = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        MIN_FIRST_RIPPLE_RADIUS = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.VoiceRippleView, 0, 0);
        try {
            this.rippleRadius = a.getInt(R.styleable.VoiceRippleView_VoiceRippleView_rippleRadius, MIN_RADIUS);
            this.iconSize = a.getInt(R.styleable.VoiceRippleView_VoiceRippleView_iconSize, MIN_ICON_SIZE);
        }
        finally {
            a.recycle();
        }
        this.buttonRadius = this.backgroundRadius = this.rippleRadius;
        this.minFirstRadius = MIN_FIRST_RIPPLE_RADIUS;
        this.handler = new Handler();
        this.setClickable(true);
        this.setEnabled(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setBackgroundRippleRatio(1.1);
        this.setRippleDecayRate(Rate.MEDIUM);
        this.setRippleSampleRate(Rate.LOW);
    }

    public void setMediaRecorder(MediaRecorder recorder) {
        this.recorder = recorder;
    }

    public void onStop() throws IllegalStateException {
        if (this.isPrepared && this.recorder != null) {
            this.recorder.stop();
        }
    }

    public void onDestroy() {
        if (this.isPrepared && this.recorder != null) {
            this.recorder.release();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.listener != null) {
            this.listener.onClick((View)this);
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == 1 && (event.getKeyCode() == 23 || event.getKeyCode() == 66) && this.listener != null) {
            this.listener.onClick((View)this);
        }
        return super.dispatchKeyEvent(event);
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.listener = listener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int viewWidthHalf = this.getMeasuredWidth() / 2;
        int viewHeightHalf = this.getMeasuredHeight() / 2;
        this.currentRenderer.render(canvas, viewWidthHalf, viewHeightHalf, this.buttonRadius, this.rippleRadius, this.backgroundRadius);
        if (this.isRecording) {
            this.recordingIcon.setBounds(viewWidthHalf - this.iconSize, viewHeightHalf - this.iconSize, viewWidthHalf + this.iconSize, viewHeightHalf + this.iconSize);
            this.recordingIcon.draw(canvas);
        } else {
            this.recordIcon.setBounds(viewWidthHalf - this.iconSize, viewHeightHalf - this.iconSize, viewWidthHalf + this.iconSize, viewHeightHalf + this.iconSize);
            this.recordIcon.draw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minw = this.getPaddingLeft() + this.getPaddingRight();
        int w = VoiceRippleView.resolveSizeAndState((int)minw, (int)widthMeasureSpec, (int)0);
        int minh = this.getPaddingBottom() + this.getPaddingTop();
        int h = VoiceRippleView.resolveSizeAndState((int)minh, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setOutputFile(String absolutePath) {
        this.recorder.setOutputFile(absolutePath);
    }

    public void setAudioSource(int audioSource) {
        this.audioSource = audioSource;
    }

    public void setOutputFormat(int outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setAudioEncoder(int audioEncoder) {
        this.audioEncoder = audioEncoder;
    }

    public void setIconSize(int dpSize) {
        this.iconSize = (int)TypedValue.applyDimension((int)1, (float)(dpSize / 2), (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.invalidate();
    }

    public void setRippleColor(int color) {
        this.currentRenderer.changeColor(color);
        this.invalidate();
    }

    public void setRippleSampleRate(Rate rate) {
        switch (rate) {
            case LOW: {
                this.thresholdRate = 5;
                break;
            }
            case MEDIUM: {
                this.thresholdRate = 10;
                break;
            }
            case HIGH: {
                this.thresholdRate = 20;
            }
        }
        this.invalidate();
    }

    public void setRippleDecayRate(Rate rate) {
        switch (rate) {
            case LOW: {
                this.rippleDecayRate = 20;
                break;
            }
            case MEDIUM: {
                this.rippleDecayRate = 10;
                break;
            }
            case HIGH: {
                this.rippleDecayRate = 5;
            }
        }
        this.invalidate();
    }

    public void setBackgroundRippleRatio(double ratio) {
        this.backgroundRippleRatio = ratio;
        this.minFirstRadius = (int)((double)MIN_FIRST_RIPPLE_RADIUS + (double)MIN_FIRST_RIPPLE_RADIUS * this.backgroundRippleRatio);
        this.invalidate();
    }

    private void drop(int amplitude) {
        int powerDb = (int)(20.0 * Math.log10((double)amplitude / 32767.0));
        int THRESHOLD = -1 * powerDb / this.thresholdRate;
        if (THRESHOLD >= 0) {
            if (this.rippleRadius - THRESHOLD >= powerDb + MIN_RADIUS + this.minFirstRadius || powerDb + MIN_RADIUS + this.minFirstRadius >= this.rippleRadius + THRESHOLD) {
                this.rippleRadius = powerDb + MIN_RADIUS + this.minFirstRadius;
                this.backgroundRadius = (int)((double)this.rippleRadius * this.backgroundRippleRatio);
            } else if ((this.backgroundRadius - this.rippleRadius) / this.rippleDecayRate == 0) {
                this.backgroundRadius = this.rippleRadius;
                this.rippleRadius = this.buttonRadius;
            } else {
                this.backgroundRadius -= (this.backgroundRadius - this.rippleRadius) / this.rippleDecayRate;
                this.rippleRadius -= (this.rippleRadius - this.buttonRadius) / this.rippleDecayRate;
            }
            this.invalidate();
        }
    }

    @Override
    public void stopRecording() {
        this.isRecording = false;
        if (this.isPrepared) {
            this.recorder.stop();
            this.recorder.reset();
            this.isPrepared = false;
            this.handler.removeCallbacks(this.updateRipple);
            this.currentRecordedTime = 0;
            this.invalidate();
            if (this.recordingListener != null) {
                this.recordingListener.onRecordingStopped();
            }
        }
    }

    @Override
    public void startRecording() {
        this.checkValidState();
        try {
            this.prepareRecord();
            this.recorder.start();
            this.isRecording = true;
            this.isPrepared = true;
            this.handler.post(this.updateRipple);
            this.invalidate();
            if (this.recordingListener != null) {
                this.recordingListener.onRecordingStarted();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"startRecording(): ", (Throwable)e);
        }
    }

    private void checkValidState() {
        if (this.thresholdRate == -1 || this.backgroundRippleRatio == -1.0 || this.rippleDecayRate == -1) {
            throw new IllegalStateException("Set rippleSampleRate, backgroundRippleRatio and rippleDecayRate before starting to record!");
        }
        if (this.audioSource == -1 || this.outputFormat == -1 || this.audioEncoder == -1) {
            throw new IllegalStateException("You have to set audioSource, outputFormat, and audioEncoder before starting to record!");
        }
    }

    private void prepareRecord() throws IOException {
        this.recorder.setAudioSource(this.audioSource);
        this.recorder.setOutputFormat(this.outputFormat);
        this.recorder.setAudioEncoder(this.audioEncoder);
        this.recorder.prepare();
    }

    public void setRecordDrawable(Drawable recordIcon, Drawable recordingIcon) {
        this.recordIcon = recordIcon;
        this.recordingIcon = recordingIcon;
        this.invalidate();
    }

    public void setRecordingListener(RecordingListener recordingListener) {
        this.recordingListener = recordingListener;
    }
}

