/*
 * Decompiled with CFR 0.152.
 */
package cucumber.junit;

import cucumber.junit.Cucumber;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RuntimeOptionsFactory {
    private Class clazz;

    public RuntimeOptionsFactory(Class clazz) {
        this.clazz = clazz;
    }

    public RuntimeOptions create() {
        ArrayList<String> args = new ArrayList<String>();
        Cucumber.Options options = this.getOptions(this.clazz);
        this.addDryRun(options, args);
        this.addMonochrome(options, args);
        this.addGlue(options, this.clazz, args);
        this.addTags(options, args);
        this.addFormats(options, args);
        this.addFeatures(options, this.clazz, args);
        return new RuntimeOptions(args.toArray(new String[args.size()]));
    }

    private Cucumber.Options getOptions(Class<?> clazz) {
        return clazz.getAnnotation(Cucumber.Options.class);
    }

    private void addDryRun(Cucumber.Options options, List<String> args) {
        if (options != null && options.dryRun()) {
            args.add("--dry-run");
        }
    }

    private void addMonochrome(Cucumber.Options options, List<String> args) {
        if (options != null && (options.monochrome() || this.runningInEnvironmentWithoutAnsiSupport())) {
            args.add("--monochrome");
        }
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private void addGlue(Cucumber.Options options, Class clazz, List<String> args) {
        if (options != null && options.glue().length != 0) {
            for (String glue : options.glue()) {
                args.add("--glue");
                args.add(glue);
            }
        } else {
            args.add("--glue");
            args.add(Utils.packageName((Class)clazz));
        }
    }

    private void addTags(Cucumber.Options options, List<String> args) {
        if (options != null) {
            for (String tags : options.tags()) {
                args.add("--tags");
                args.add(tags);
            }
        }
    }

    private void addFormats(Cucumber.Options options, List<String> args) {
        if (options != null && options.format().length != 0) {
            for (String format : options.format()) {
                args.add("--format");
                args.add(format);
            }
        } else {
            args.add("--format");
            args.add("null");
        }
    }

    private void addFeatures(Cucumber.Options options, Class clazz, List<String> args) {
        if (options != null && options.features().length != 0) {
            Collections.addAll(args, options.features());
        } else {
            args.add(Utils.packagePath((Class)clazz));
        }
    }
}

