/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java8;

import cucumber.api.java8.StepdefBody;
import cucumber.runtime.CucumberException;
import cucumber.runtime.java.TypeIntrospector;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import jdk.internal.org.objectweb.asm.Type;
import sun.reflect.ConstantPool;

public class ConstantPoolTypeIntrospector
implements TypeIntrospector {
    private static final Method Class_getConstantPool;
    public static final TypeIntrospector INSTANCE;

    public java.lang.reflect.Type[] getGenericTypes(Class<? extends StepdefBody> clazz, Class<? extends StepdefBody> interfac3) throws Exception {
        ConstantPool constantPool = (ConstantPool)Class_getConstantPool.invoke(clazz, new Object[0]);
        String typeString = this.getLambdaTypeString(constantPool);
        int typeParameterCount = interfac3.getTypeParameters().length;
        Type[] argumentTypes = Type.getArgumentTypes(typeString);
        List<Type> interestingArgumentTypes = Arrays.asList(argumentTypes).subList(argumentTypes.length - typeParameterCount, argumentTypes.length);
        java.lang.reflect.Type[] typeArguments = new java.lang.reflect.Type[typeParameterCount];
        for (int i = 0; i < typeParameterCount; ++i) {
            typeArguments[i] = Class.forName(interestingArgumentTypes.get(i).getClassName());
        }
        return typeArguments;
    }

    private String getLambdaTypeString(ConstantPool constantPool) {
        int size = constantPool.getSize();
        String[] memberRef = null;
        for (int i = size - 1; i > -1; --i) {
            try {
                memberRef = constantPool.getMemberRefInfoAt(i);
                return memberRef[2];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new CucumberException("Couldn't find memberRef.");
    }

    static {
        try {
            Class_getConstantPool = Class.class.getDeclaredMethod("getConstantPool", new Class[0]);
            Class_getConstantPool.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        INSTANCE = new ConstantPoolTypeIntrospector();
    }
}

