/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.converters;

import cucumber.runtime.CucumberException;
import cucumber.runtime.ParameterType;
import cucumber.runtime.converters.CalendarConverter;
import cucumber.runtime.converters.ConverterWithFormat;
import cucumber.runtime.converters.DateConverter;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class TimeConverter<T>
extends ConverterWithFormat<T> {
    final Locale locale;
    private final List<DateFormat> formats = new ArrayList<DateFormat>();
    private SimpleDateFormat onlyFormat;

    TimeConverter(Locale locale, Class[] convertibleTypes) {
        super(convertibleTypes);
        this.locale = locale;
        this.addFormat(3, locale);
        this.addFormat(2, locale);
        this.addFormat(1, locale);
        this.addFormat(0, locale);
    }

    void addFormat(int style, Locale locale) {
        this.add(DateFormat.getDateInstance(style, locale));
    }

    void add(DateFormat dateFormat) {
        dateFormat.setLenient(false);
        this.formats.add(dateFormat);
    }

    @Override
    public List<? extends Format> getFormats() {
        return this.onlyFormat == null ? this.formats : Arrays.asList(this.onlyFormat);
    }

    @Override
    public String toString(Object obj) {
        if (obj instanceof Calendar) {
            obj = ((Calendar)obj).getTime();
        }
        return super.toString(obj);
    }

    public void setOnlyFormat(String dateFormatString, Locale locale) {
        this.onlyFormat = new SimpleDateFormat(dateFormatString, locale);
        this.onlyFormat.setLenient(false);
    }

    public void removeOnlyFormat() {
        this.onlyFormat = null;
    }

    public static TimeConverter getInstance(ParameterType parameterType, Locale locale) {
        if (Date.class.isAssignableFrom(parameterType.getRawType())) {
            return new DateConverter(locale);
        }
        if (Calendar.class.isAssignableFrom(parameterType.getRawType())) {
            return new CalendarConverter(locale);
        }
        throw new CucumberException("Unsupported time type: " + parameterType.getRawType());
    }

    public static List<Class> getTimeClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Date.class);
        classes.add(Calendar.class);
        return classes;
    }
}

