/*
 * Decompiled with CFR 0.152.
 */
package info.androidhive.barcode;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import info.androidhive.barcode.R;

public class ScannerOverlay
extends ViewGroup {
    private float left;
    private float top;
    private float endY;
    private int rectWidth;
    private int rectHeight;
    private int frames;
    private boolean revAnimation;
    private int lineColor;
    private int lineWidth;

    public ScannerOverlay(Context context) {
        super(context);
    }

    public ScannerOverlay(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScannerOverlay(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ScannerOverlay, 0, 0);
        this.rectWidth = a.getInteger(R.styleable.ScannerOverlay_square_width, this.getResources().getInteger(R.integer.scanner_rect_width));
        this.rectHeight = a.getInteger(R.styleable.ScannerOverlay_square_height, this.getResources().getInteger(R.integer.scanner_rect_height));
        this.lineColor = a.getColor(R.styleable.ScannerOverlay_line_color, ContextCompat.getColor((Context)context, (int)R.color.scanner_line));
        this.lineWidth = a.getInteger(R.styleable.ScannerOverlay_line_width, this.getResources().getInteger(R.integer.line_width));
        this.frames = a.getInteger(R.styleable.ScannerOverlay_line_speed, this.getResources().getInteger(R.integer.line_width));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.left = (w - this.dpToPx(this.rectWidth)) / 2;
        this.endY = this.top = (float)((h - this.dpToPx(this.rectHeight)) / 2);
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public int dpToPx(int dp) {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean cornerRadius = false;
        Paint eraser = new Paint();
        eraser.setAntiAlias(true);
        eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        RectF rect = new RectF(this.left, this.top, (float)this.dpToPx(this.rectWidth) + this.left, (float)this.dpToPx(this.rectHeight) + this.top);
        canvas.drawRoundRect(rect, (float)cornerRadius, (float)cornerRadius, eraser);
        Paint line = new Paint();
        line.setColor(this.lineColor);
        line.setStrokeWidth(Float.valueOf(this.lineWidth).floatValue());
        if (this.endY >= this.top + (float)this.dpToPx(this.rectHeight) + (float)this.frames) {
            this.revAnimation = true;
        } else if (this.endY == this.top + (float)this.frames) {
            this.revAnimation = false;
        }
        this.endY = this.revAnimation ? (this.endY -= (float)this.frames) : (this.endY += (float)this.frames);
        canvas.drawLine(this.left, this.endY, this.left + (float)this.dpToPx(this.rectWidth), this.endY, line);
        this.invalidate();
    }
}

