package im.zego.zegoexpress.utils;

import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.Toast;

import java.io.File;

public class ZegoJniUtil {

    static void showToastMsg(String msg, Context context) {
        final Context mContext = context;
        final String mMsg = msg;
        //todo 是否有可能线程不安全
        if (mContext != null) {
            try {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    Toast.makeText(mContext, msg, Toast.LENGTH_LONG).show();
                } else {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext, mMsg, Toast.LENGTH_LONG).show();
                        }
                    });
                    handler = null;
                }
            } catch (Exception e) {
                //do nothing
            }
        }
    }

}
