package im.zego.zegoexpress.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;

import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.entity.*;
import java.nio.ByteBuffer;

final class ZegoExpressEngineJniAPI {

    public native static int setBuiltInSpeakerOnJni(boolean enable);

    public native static int sendBarrageMessageJni(String roomID, String message);

    public native static int sendCustomVideoCaptureTextureDataJni(int textureID, int width, int height, double referenceTimeMillisecond, int channel);

    public native static int sendCustomVideoCaptureRawDataJni(ByteBuffer data, int dataLength, int format, int[] strides, int width, int height, long referenceTimeMillisecond, int channel, int rotation);

    public native static int setCustomVideoCaptureFillModeJni(int value, int channel);

    public native static int setCustomVideoCaptureFlipModeJni(int value, int channel);

    public native static SurfaceTexture getCustomVideoCaptureSurfaceTextureJni(int channel);

    /* zego-express-engine-jni */
    public static native int engineInitJni(long appID, String appSign, boolean isTestEnvironment, int scenario, Context context);

    public static native void setEngineInitConfigToJni(ZegoEngineConfig engineConfig, String logPath, long logSize, String advanceConfig);

    public static native int engineUninitAsyncJni();

    public static native String getVersionJni();

    public static native void setDebugVerboseJni(boolean enable, int language);

    public static native void uploadLogJni();

    /* zego-express-room.h */
    public static native int loginRoomJni(ZegoUser user, String roomID, ZegoRoomConfig config);

    public static native int loginRoomJni(ZegoUser user, String roomID, ZegoRoomConfig config, String token);

    public static native int loginMultiRoomJni(String roomID, ZegoRoomConfig config);

    public static native int logoutRoomJni(String roomID);

    public static native int setRoomExtraInfoJni(String roomID, String key, String value);

    /* zego-express-publisher.h */

    public static native int ZegoVideoMirrorModeJni(int viewMode, int channel);

    public static native int setCapturePipelineScaleModeJni(int zegoCapturePipelineScaleMode);

    public static native int enableCheckPocJni(boolean enable);

    public static native int setAppOrientationJni(int orientation, int channel);

    public static native int startPreviewJni(Object view, int viewMode, int backgroundColor, int channel);

    public static native int stopPreviewJni(int channel);

//    public static native int setLatencyModeJni(int latencyMode);
//
//    public static native int setAudioBitrateJni(int bitrate);
//
//    public static native int setAudioChannelCountJni(int channelCount);

    public static native int setVideoConfigJni(ZegoVideoConfig videoConfig, int channel, int codeid);

    public static native int startPublishingStreamJni(String streamID, int channel);

    public static native int stopPublishingStreamJni(int channel);

    public static native int setPublishStreamEncryptionKeyJni(String key, int channel);

    public static native int takePublishStreamSnapshotJni(int channel);

    public static native int mutePublishStreamAudioJni(boolean mute, int channel);

    public static native int mutePublishStreamVideoJni(boolean mute, int channel);

    public static native int setStreamExtraInfoJni(String extraInfo, int channel);

    public static native int setCaptureVolumeJni(int volume);

    public static native int enableTrafficControlJni(boolean enable, int controlTypeBitMask);

    public static native int addPublishCdnUrlJni(String streamID, String targetURL);

    public static native int enablePublishDirectToCDNJni(boolean enable, ZegoCDNConfig zegoCDNConfig, int value);

    public static native int removePublishCdnUrlJni(String streamID, String targetURL);

    public static native int setPublishWatermarkJni(ZegoWatermark watermark, boolean isPreviewVisible, int channel);

    public static native int enableHardwareEncoderJni(boolean enable);


    public static native int setSEIConfigJni(ZegoSEIConfig config);

    public static native int sendSEIJni(byte[] data, int channel);

    /* zego-express-player.h */

    public static native int startPlayingStreamJni(String streamID, Object view, int viewMode, int bacgroundColor, ZegoCDNConfig zegoCDNConfig, int layer,int resourceMode);

    public static native int stopPlayingStreamJni(String streamID);

    public static native int setPlayStreamDecryptionKeyJni(String streamID, String key);

    public static native int takePlayStreamSnapshotJni(String streamID);

    public static native int setPlayVolumeJni(String streamID, int volume);

    public static native int setPlayStreamVideoLayerJni(String streamID, int videoLayer);

    public static native int setPlayStreamBufferIntervalRangeJni(String streamID, int minBufferInterval, int maxBufferInterval);

    public static native int mutePlayStreamAudioJni(String streamID, boolean mute);

    public static native int mutePlayStreamVideoJni(String streamID, boolean mute);

    public static native int enableHardwareDecoderJni(boolean enable);

    /* zego-express-mixer.h */
    public static native int startMixerJni(ZegoMixerTask task);

    public static native int stopMixerJni(ZegoMixerTask task);

    /* zego-express-device.h */
    public static native int muteMicrophoneJni(boolean mute);

    public static native int muteSpeakerJni(boolean mute);

    public static native int enableCameraJni(boolean enable, int channel);

    public static native int useFrontCameraJni(boolean enable, int channel);

    public static native int startSoundLevelMonitorJni(int timeInMS);

    public static native int stopSoundLevelMonitorJni();

    public static native boolean isMicrophoneMutedJni();

    public static native int startFrequencySpectrumMonitorJni(int timeInMS);

    public static native int stopFrequencySpectrumMonitorJni();

    public static native int enableAudioCaptureDeviceJni(boolean enable);

    public static native int setMinVideoBitrateForTrafficControlJni(int bitrate, int value);

    public static native int setCameraZoomFactorJni(float zoomFactor, int channel);

    public static native float getCameraMaxZoomFactorJni(int channel);

    /* zego-express-preprocess.h */
    public static native int enableAECJni(boolean enable);

    public static native int setAECModeJni(int mode);

    public static native int enableAGCJni(boolean enable);

    public static native int enableANSJni(boolean enable);

    public static native int enableTransientANSJni(boolean enable);

    public static native int setVoiceChangerPresetJni(int preset);

    public static native int setVoiceChangerParamJni(float param);

    public static native int enableVirtualStereoJni(boolean enable, int angle);

    public static native int setReverbPresetJni(int preset);

    public static native int setReverbParamJni(float damping, float dryWetRatio, float reverberance, float roomSize);

    public static native int setReverbAdvancedParam(float roomSize, float reverberance, float damping, boolean wetOnly, float wetGain, float dryGain, float toneLow, float toneHigh, float preDelay, float stereoWidth);

    public static native int setReverbEchoParamJni(ZegoReverbEchoParam param);

    public static native int enableBeautifyJni(int feature, int channel);

    public static native int setBeautifyOptionJni(ZegoBeautifyOption option, int channel);



    public static native boolean isSpeakerMutedJni();

    /* zego-express-im.h */
    public static native int sendBroadcastMessageJni(String roomID, String message);

    public static native int sendCustomerMessageJni(String command, ZegoUser[] toUserList, String roomID);

    public static native int enableCustomAudioCaptureProcessingJni(boolean enable, int samples, int channel, int sampleRate);

    public static native int enableCustomAudioRemoteProcessingJni(boolean enable, int samples, int channel, int sampleRate);

    /* zego-express-record.h */
    public static native int stopRecordingCapturedDataJni(int channel);

    public static native int startRecordingCapturedDataJni(String filePath, int recordType, int channel);

    /* zego-express-custom-audio-io.h */
    public static native int enableCustomAudioIOJni(boolean enable, int sourceType, int channel);

    public static native int fetchCustomAudioRenderPCMDataJni(ByteBuffer data, int dataLength, int sampleRate, int audioChannel);

    public static native int sendCustomAudioCapturePCMDataJni(ByteBuffer data, int dataLength, int sampleRate, int audioChannel, int channel);

    public static native int sendCustomAudioCaptureAACDataJni(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, int sampleRate, int audioChannel, int publishChannel);

    public static native int enableAudioDataCallbackJni(boolean enable, int callbackBitMask, int sampleRate, int channel);

    public static native int setANSModeJni(int value);

    public static native ZegoAudioConfig getAudioConfigJni();

    public static native ZegoVideoConfig getVideoConfigJni(int value);

    public static native String printDebugInfoJni(int level, int module, String funcName, int errorCode, Object... args);




    public static native int sendCustomVideoCaptureEncodedDataJni(ByteBuffer data, int dataLength, int value, boolean isKeyFrame, int width, int height, ByteBuffer seiData, int seiDataLength, int rotation, long referenceTimeMillisecond, int value1);

    public static native int setHeadphoneMonitorVolumeJni(int volume);

    public static native int enableHeadphoneMonitorJni(boolean enable);

    /* zego-express-custom-video-io.h */
    public static native int enableCustomVideoCaptureJni(boolean enable, ZegoCustomVideoCaptureConfig config, int value);

    public static native int enableCustomVideoRenderJni(boolean enable, ZegoCustomVideoRenderConfig config);

    public static native int enableHeadphoneAECJni(boolean enable);

    public static native int setAudioEqualizerGainJni(int bandIndex, float bandGai);

    public static native void showDebugMessageBoxJni(int language, int errorCode, String funcName, String msg);

    public static native int setAudioConfigJni(int bitrate, int channel, int codecID);

    public static native int enableAudioMixingJni(boolean enable);

    public static native int muteLocalAudioMixingJni(boolean mute);

    public static native int setAudioMixingVolumeJniWithType(int volume, int type);

    public static native int setAudioMixingVolumeJni(int volume);

    public static native int switchRoomJni(String fromRoomID, String toRoomID, ZegoRoomConfig config);

    public static native int setAudioCaptureStereoModeJni(int value);

    /* zego-express-utilities.h */
    public static native int startPerformanceMonitorJni(int millisecond);

    public static native int stopPerformanceMonitorJni();

    public static native int testNetworkConnectivityJni() ;

    public static native int startNetworkSpeedTest(ZegoNetworkSpeedTestConfig config);

    public static native int stopNetworkSpeedTest();


    /* Private methods used by the upper framework */
    public static native void setPlatformLanguageJni(int platform);

    public static native void logNoticeJni(String log, String module);

}
