package com.zego.zegoavkit2.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;

import java.io.File;

/**
 * Copyright © 2017 Zego. All rights reserved.
 * log工具类.
 */
final public class ZegoLogUtil {

    static public String getLogPath(Context context) {

        if (context == null) {
            return null;
        }

        File dir = null;
        String mountState = null;
        try {
            mountState = Environment.getExternalStorageState(); // 在 5.0/5.1 系统上可能会出现 NullPointerException
        } catch(Exception e) {
            e.printStackTrace();
            mountState = null;
        }

        // 使用内置存储卡
        if (Environment.MEDIA_MOUNTED.equals(mountState)) {
            // 容错处理
            File externalFilesDir = context.getExternalFilesDir(null);
            if (externalFilesDir != null) {
                String externalFilesDirPath = externalFilesDir.getAbsolutePath();
                if (!TextUtils.isEmpty(externalFilesDirPath)) {
                    dir = new File(externalFilesDirPath);
                }
            }
        }
        //使用手机内存
        if (dir == null) {
            File filesDir = context.getFilesDir();
            // 容错处理
            if (filesDir != null) {
                String filesDirPath = filesDir.getAbsolutePath();
                if (!TextUtils.isEmpty(filesDirPath)) {
                    dir = new File(filesDirPath);
                }
            }
        }

        if (dir == null) {
            return null;
        }

        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                return null;
            }
        }

        return dir.getAbsolutePath().toString();
    }

    static public String getTemporaryFolder(Context context) {
        if (context == null) {
            return null;
        }

        File dir = null;
        // 使用内置存储卡
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            // 容错处理
            File externalCacheDir = context.getExternalCacheDir();
            if (externalCacheDir != null) {
                String externalCacheDirPath = externalCacheDir.getAbsolutePath();
                if (!TextUtils.isEmpty(externalCacheDirPath)) {
                    dir = new File(externalCacheDirPath);
                }
            }
        }
        //使用手机内存
        if (dir == null) {
            File cacheDir = context.getCacheDir();
            // 容错处理
            if (cacheDir != null) {
                String cacheDirPath = cacheDir.getAbsolutePath();
                if (!TextUtils.isEmpty(cacheDirPath)) {
                    dir = new File(cacheDirPath);
                }
            }
        }

        if (dir == null) {
            return null;
        }

        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                return null;
            }
        }

        return dir.getAbsolutePath().toString();
    } 
}
