package com.zego.zegoavkit2.hardwaremonitor;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Debug.MemoryInfo;

import java.lang.reflect.Method;

public class ZegoMEMUtils {
    /**
     * 获取内存信息：total、free、buffers、cached，单位MB
     * 
     * @return 内存信息｛total,free,buffers,cached｝
     */
    public static long[] getMemInfo() {
        long memInfo[] = new long[4];
        try {
            Class<?> procClazz = Class.forName("android.os.Process");
            Class<?> paramTypes[] = new Class[] { String.class, String[].class, long[].class };
            Method readProclines = procClazz.getMethod("readProcLines", paramTypes);
            Object args[] = new Object[3];
            final String[] memInfoFields = new String[] { "MemTotal:", "MemFree:", "Buffers:", "Cached:" };
            long[] memInfoSizes = new long[memInfoFields.length];
            memInfoSizes[0] = 30;
            memInfoSizes[1] = -30;
            args[0] = new String("/proc/meminfo");
            args[1] = memInfoFields;
            args[2] = memInfoSizes;
            if (null != readProclines) {
                readProclines.invoke(null, args);
                for (int i = 0; i < memInfoSizes.length; i++) {
                    memInfo[i] = memInfoSizes[i] / 1024;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return memInfo;
    }

    /**
     * 获取进程内存Private Dirty数据
     * 
     * @param context Android上下文
     * @param pid 进程ID
     * @return {nativePrivateDirty,dalvikPrivateDirty,TotalPrivateDirty}
     */
    public static long[] getPrivDirty(Context context, int pid) {

        ActivityManager mAm = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        int[] pids = new int[1];
        pids[0] = pid;
        MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
        MemoryInfo pidMemoryInfo = memoryInfoArray[0];
        long[] value = new long[3]; // Natvie Dalvik Total
        value[0] = pidMemoryInfo.nativePrivateDirty;
        value[1] = pidMemoryInfo.dalvikPrivateDirty;
        value[2] = pidMemoryInfo.getTotalPrivateDirty();
        return value;
    }

    /**
     * 获取进程内存PSS数据
     *
     * @param context Android上下文
     * @param pid 进程ID
     * @return {nativePss,dalvikPss,TotalPss}
     */
    public static long[] getPSS(Context context, int pid) {
        long[] value = new long[3]; // Natvie Dalvik Total
        if (pid >= 0) {
            int[] pids = new int[1];
            pids[0] = pid;
            ActivityManager mAm = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
            MemoryInfo pidMemoryInfo = memoryInfoArray[0];

            value[0] = pidMemoryInfo.nativePss;
            value[1] = pidMemoryInfo.dalvikPss;
            value[2] = pidMemoryInfo.getTotalPss();
        } else {
            value[0] = 0;
            value[1] = 0;
            value[2] = 0;
        }

        return value;
    }

    /**
     * 获取本进程的内存Heap数据
     * 注：该数值与Java方式虚拟机算法的内存值一致，和Dumpsys meminfo方式的数值有较大出入
     * @return {NativeSize,NativeAllocatedSize,DalvikSize,DalvikAllocatedSize,HeapSize,HeapAllocatedSize}
     */
    public static long[] getHeap() {
        long[] value = new long[6]; // NativeSize,NativeAllocatedSize,DalvikSize,DalvikAllocatedSize,HeapSize,HeapAllocatedSize
        long[] nativeValue = getHeapNative();
        long[] dalvikValue = getHeapDalvik();
        value[0] = nativeValue[0];
        value[1] = nativeValue[1];
        value[2] = dalvikValue[0];
        value[3] = dalvikValue[1];
        value[4] = nativeValue[0] + dalvikValue[0];
        value[5] = nativeValue[1] + dalvikValue[1];
        return value;
    }

    public static long[] getHeapNative() {
        long[] value = new long[2];
        value[0] = Debug.getNativeHeapSize() >> 10;
        value[1] = Debug.getNativeHeapAllocatedSize() >> 10;
        return value;
    }

    public static long[] getHeapDalvik() {
        long[] value = new long[2];
        value[0] = Runtime.getRuntime().totalMemory() >> 10; // Runtime取的就是虚拟机算法的内存值
        value[1] = (Runtime.getRuntime().totalMemory() - Runtime
                .getRuntime().freeMemory()) >> 10;
        return value;
    }
}