/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.SystemClock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VeBitmap {
    public static Bitmap getBitmap(Context context, int n, int n2, String string) {
        int n3 = string.indexOf(58);
        if (n3 == -1) {
            return null;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1, string.length());
        if (string2.compareTo("asset") == 0) {
            return VeBitmap.getBitmapFromAsset(context, string3);
        }
        if (string2.compareTo("file") == 0) {
            return VeBitmap.getBitmapFromPath(context, n, n2, string3);
        }
        return null;
    }

    public static Bitmap getBitmapFromAsset(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        Bitmap bitmap = null;
        try {
            InputStream inputStream = assetManager.open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromPath(Context context, int n, int n2, String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        options.inSampleSize = VeBitmap.calculateInSampleSize(options, n, n2);
        return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6 = n3 / 2;
            int n7 = n4 / 2;
            while (n6 / n5 >= n2 && n7 / n5 >= n) {
                n5 *= 2;
            }
        }
        return n5;
    }

    public static Bitmap createBitmapRGBA(int n, int n2) {
        return Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static int saveBitmap(Bitmap bitmap) {
        File file = new File("/sdcard/", "snapshot-" + SystemClock.uptimeMillis() + ".jpg");
        try {
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }
}

