/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Surface;
import com.zego.ve.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 2.0;
    private static final int BITRATE_CORRECTION_STEPS = 10;
    private static MediaCodecVideoEncoder runningInstance = null;
    private static MediaCodecVideoEncoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwEncoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private Surface inputSurface;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String HEVC_MIME_TYPE = "video/hevc";
    private static final MediaCodecProperties qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties intelVp8HwProperties = new MediaCodecProperties("OMX.Intel.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties[] vp8HwList = new MediaCodecProperties[]{qcomVp8HwProperties, exynosVp8HwProperties, intelVp8HwProperties};
    private static final MediaCodecProperties qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties mtkH264HwProperties = new MediaCodecProperties("OMX.MTK.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties kirinH264HwProperties = new MediaCodecProperties("OMX.IMG.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties rkH264HwProperties = new MediaCodecProperties("OMX.rk.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties kirin960H264HwProperties = new MediaCodecProperties("OMX.hisi.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties winnerH264HwProperties = new MediaCodecProperties("OMX.allwinner.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties tiH264HwProperties = new MediaCodecProperties("OMX.TI.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties mstarH264HwProperties = new MediaCodecProperties("OMX.MS.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties freescaleH264HwProperties = new MediaCodecProperties("OMX.Freescale.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties sprdH264HwProperties = new MediaCodecProperties("OMX.sprd.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties intelH264HwProperties = new MediaCodecProperties("OMX.Intel.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties nvidiaH264HwProperties = new MediaCodecProperties("OMX.Nvidia.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties[] h264HwList = new MediaCodecProperties[]{qcomH264HwProperties, exynosH264HwProperties, mtkH264HwProperties, kirinH264HwProperties, kirin960H264HwProperties, tiH264HwProperties, intelH264HwProperties, nvidiaH264HwProperties, rkH264HwProperties, winnerH264HwProperties, mstarH264HwProperties, freescaleH264HwProperties, sprdH264HwProperties};
    private static final MediaCodecProperties qcomHEVCHwProperties = new MediaCodecProperties("OMX.qcom.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties kirin960HEVCHwProperties = new MediaCodecProperties("OMX.hisi.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties kirinHEVCHwProperties = new MediaCodecProperties("OMX.IMG.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties mtkHEVCHwProperties = new MediaCodecProperties("OMX.MTK.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties exynosHEVCHwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
    private static final MediaCodecProperties[] hevcHwList = new MediaCodecProperties[]{qcomHEVCHwProperties, kirin960HEVCHwProperties, kirinHEVCHwProperties, mtkHEVCHwProperties, exynosHEVCHwProperties};
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "EML-AL00", "XT1079", "PACM00", "SM-G9250"};
    private static boolean enableWhitelist = true;
    private static final String[] HW_BLACKLISTS = new String[]{"omx.google.", "omx.ffmpeg.", "omx.pv", "omx.k3.ffmpeg.", "omx.avcodec.", "omx.ittiam.", "omx.sec.avc.sw.", "omx.marvell.video.h264encoder"};
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int COLOR_FormatYUV420Flexible = 2135033992;
    private static final int[] supportedColorList = new int[]{21, 2135033992, 2141391872, 2141391876, 19, 20, 2130706688, 2130708361};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361};
    private VideoCodecType type;
    private int colorFormat;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private double bitrateObservationTimeMs;
    private int bitrateAdjustmentScaleExp;
    private int targetBitrateBps;
    private int targetFps;
    private int originFps;
    private long forcedKeyFrameMs;
    private long lastKeyFrameMs;
    private ByteBuffer configData = null;
    private VImage cacheImage = new VImage();

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Log.d((String)TAG, (String)"Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Log.w((String)TAG, (String)"VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Log.w((String)TAG, (String)"VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Log.w((String)TAG, (String)"H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableHEVCHwCodec() {
        Log.w((String)TAG, (String)"HEVC encoding is disabled by application.");
        hwEncoderDisabledTypes.add(HEVC_MIME_TYPE);
    }

    public static boolean isVp8HwSupported(boolean bl) {
        return false;
    }

    public static boolean isH264HwSupported(boolean bl) {
        enableWhitelist = bl;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, supportedColorList) != null;
    }

    public static boolean isHEVCHwSupported(boolean bl) {
        enableWhitelist = bl;
        return !hwEncoderDisabledTypes.contains(HEVC_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(HEVC_MIME_TYPE, hevcHwList, supportedColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, supportedSurfaceColorList) != null;
    }

    public static String getCodecName() {
        EncoderProperties encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, supportedColorList);
        return encoderProperties.codecName;
    }

    /*
     * WARNING - void declaration
     */
    private static EncoderProperties findHwEncoder(String string, MediaCodecProperties[] mediaCodecPropertiesArray, int[] nArray) {
        List<String> list;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (string.equals(H264_MIME_TYPE) && (list = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Log.w((String)TAG, (String)("Model: " + Build.MODEL + " has black listed H.264 encoder."));
            return null;
        }
        try {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                void var11_27;
                MediaCodecInfo.CodecCapabilities codecCapabilities;
                MediaCodecInfo mediaCodecInfo = null;
                try {
                    mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.e((String)TAG, (String)"Cannot retrieve encoder codec info", (Throwable)illegalArgumentException);
                }
                if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
                String string2 = null;
                for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string3.equals(string)) continue;
                    string2 = mediaCodecInfo.getName();
                    break;
                }
                if (string2 == null) continue;
                Log.d((String)TAG, (String)("Found candidate encoder " + string2));
                boolean bl = false;
                BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
                if (enableWhitelist) {
                    for (MediaCodecProperties mediaCodecProperties : mediaCodecPropertiesArray) {
                        if (!string2.startsWith(mediaCodecProperties.codecPrefix)) continue;
                        if (Build.VERSION.SDK_INT < mediaCodecProperties.minSdk) {
                            Log.w((String)TAG, (String)("Codec " + string2 + " is disabled due to SDK version " + Build.VERSION.SDK_INT));
                            continue;
                        }
                        if (mediaCodecProperties.bitrateAdjustmentType != BitrateAdjustmentType.NO_ADJUSTMENT) {
                            bitrateAdjustmentType = mediaCodecProperties.bitrateAdjustmentType;
                            Log.w((String)TAG, (String)("Codec " + string2 + " requires bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType)));
                        }
                        bl = true;
                        break;
                    }
                } else {
                    String string3;
                    int n2 = 0;
                    string3 = string2.toLowerCase();
                    for (String string4 : HW_BLACKLISTS) {
                        if (!string3.startsWith(string4)) continue;
                        n2 = 1;
                        break;
                    }
                    boolean bl2 = bl = n2 == 0;
                }
                if (!bl) continue;
                try {
                    codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.e((String)TAG, (String)"Cannot retrieve encoder capabilities", (Throwable)illegalArgumentException);
                    continue;
                }
                int[] nArray2 = codecCapabilities.colorFormats;
                int n4 = nArray2.length;
                boolean bl3 = false;
                while (var11_27 < n4) {
                    int n = nArray2[var11_27];
                    Log.d((String)TAG, (String)("Color: 0x" + Integer.toHexString(n)));
                    ++var11_27;
                }
                boolean bl32 = false;
                n4 = 0;
                for (int n : nArray) {
                    for (int n2 : codecCapabilities.colorFormats) {
                        MediaCodecInfo.EncoderCapabilities encoderCapabilities;
                        if (n2 != n) continue;
                        Log.d((String)TAG, (String)("Found target encoder for mime " + string + " : " + string2 + ". Color: 0x" + Integer.toHexString(n2) + ". Bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType)));
                        if (Build.VERSION.SDK_INT >= 21 && (encoderCapabilities = codecCapabilities.getEncoderCapabilities()) != null && encoderCapabilities.isBitrateModeSupported(2)) {
                            bl32 = true;
                            Log.d((String)TAG, (String)"is CBR Mode supported");
                        }
                        if (Build.VERSION.SDK_INT >= 23 && string.equals(H264_MIME_TYPE)) {
                            encoderCapabilities = MediaFormat.createVideoFormat((String)string, (int)640, (int)480);
                            encoderCapabilities.setInteger("profile", 1);
                            n4 = codecCapabilities.isFormatSupported((MediaFormat)encoderCapabilities);
                        }
                        return new EncoderProperties(string2, n2, bitrateAdjustmentType, bl32, n4 != 0);
                    }
                }
            }
        }
        catch (Exception exception) {
            MediaCodecVideoEncoder.printStackTrace();
        }
        return null;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Log.d((String)TAG, (String)"MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Log.d((String)TAG, (String)stackTraceElement.toString());
            }
        }
    }

    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    boolean initEncode(int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        Log.d((String)TAG, (String)("Java initEncode: " + n2 + " x " + n3 + ". @ " + n4 / 1000 + " kbps. Fps: " + n5 + " useSurface:" + bl));
        this.width = n2;
        this.height = n3;
        this.forcedKeyFrameMs = 0L;
        this.lastKeyFrameMs = -1L;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        String string = "";
        EncoderProperties encoderProperties = null;
        VideoCodecType videoCodecType = VideoCodecType.values()[n];
        int n8 = -1;
        int n9 = -1;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264_AVC) {
            Log.d((String)TAG, (String)"init h264 encoder");
            string = H264_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HwList, bl ? supportedSurfaceColorList : supportedColorList);
            if (encoderProperties.supportedProfile) {
                if (n7 != 0) {
                    n8 = 8;
                    n9 = 32768;
                } else {
                    n8 = 1;
                    n9 = n2 * n3 / 256 <= 8192 ? 2048 : 32768;
                }
            }
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H265) {
            Log.d((String)TAG, (String)"init hevc encoder");
            string = HEVC_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(HEVC_MIME_TYPE, hevcHwList, bl ? supportedSurfaceColorList : supportedColorList);
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            Log.d((String)TAG, (String)"init vp8 encoder");
            string = VP8_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, vp8HwList, bl ? supportedSurfaceColorList : supportedColorList);
            if (this.type == VideoCodecType.VIDEO_CODEC_VP8 && encoderProperties.codecName.startsWith(MediaCodecVideoEncoder.qcomVp8HwProperties.codecPrefix)) {
                if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                    this.forcedKeyFrameMs = n6 * 1000;
                } else if (Build.VERSION.SDK_INT == 23) {
                    this.forcedKeyFrameMs = n6 * 1000;
                } else if (Build.VERSION.SDK_INT > 23) {
                    this.forcedKeyFrameMs = n6 * 1000;
                }
            }
        } else {
            Log.e((String)TAG, (String)("not support this encoder: " + n));
            return false;
        }
        int n10 = n6;
        if (encoderProperties == null) {
            throw new RuntimeException("Can not find HW encoder for h264");
        }
        runningInstance = this;
        this.colorFormat = encoderProperties.colorFormat;
        this.bitrateAdjustmentType = encoderProperties.bitrateAdjustmentType;
        n5 = Math.min(n5, 30);
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT) {
            this.originFps = n5;
        }
        Log.d((String)TAG, (String)("Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Initial fps: " + n5));
        this.targetBitrateBps = n4;
        this.targetFps = n5;
        this.bitrateAccumulatorMax = (double)this.targetBitrateBps / 8.0;
        this.bitrateAccumulator = 0.0;
        this.bitrateObservationTimeMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
            mediaFormat.setInteger("bitrate", this.targetBitrateBps);
            if (encoderProperties.supportedCBR && n7 == 0) {
                mediaFormat.setInteger("bitrate-mode", 2);
            }
            mediaFormat.setInteger("color-format", encoderProperties.colorFormat);
            mediaFormat.setInteger("frame-rate", this.targetFps);
            mediaFormat.setInteger("i-frame-interval", n10);
            if (n8 != -1) {
                mediaFormat.setInteger("profile", n8);
                mediaFormat.setInteger("level", n9);
                if (n7 != 0) {
                    mediaFormat.setInteger("priority", 1);
                    mediaFormat.setInteger("latency", 3);
                    mediaFormat.setInteger("max-bframes", n7);
                    mediaFormat.setInteger("android._prefer-b-frames", 1);
                }
            }
            Log.d((String)TAG, (String)("  Format: " + mediaFormat));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
            this.type = this.type;
            if (this.mediaCodec == null) {
                Log.e((String)TAG, (String)"Can not create media encoder");
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            if (bl) {
                this.inputSurface = this.mediaCodec.createInputSurface();
            }
            this.mediaCodec.start();
            if (Build.VERSION.SDK_INT < 21) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                Log.d((String)TAG, (String)("Output buffers: " + this.outputBuffers.length));
            }
            if (!bl) {
                this.stride = 0;
                this.sliceHeight = 0;
                if (Build.VERSION.SDK_INT < 21) {
                    this.inputBuffers = this.mediaCodec.getInputBuffers();
                    Log.d((String)TAG, (String)("Input buffers: " + this.inputBuffers.length));
                } else {
                    MediaFormat mediaFormat2 = this.mediaCodec.getInputFormat();
                    if (mediaFormat2.containsKey("stride")) {
                        this.stride = mediaFormat2.getInteger("stride");
                    }
                    if (mediaFormat2.containsKey("slice-height")) {
                        this.sliceHeight = mediaFormat2.getInteger("slice-height");
                    }
                    Log.d((String)TAG, (String)("Input frame stride and slice height: " + this.stride + " x " + this.sliceHeight));
                }
                this.stride = Math.max(n2, this.stride);
                this.sliceHeight = Math.max(n3, this.sliceHeight);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"initEncode failed", (Throwable)illegalStateException);
            MediaCodecVideoEncoder.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            MediaCodecVideoEncoder.printStackTrace();
            return false;
        }
        return true;
    }

    void checkKeyFrameRequired(boolean bl, long l) {
        long l2 = (l + 500L) / 1000L;
        if (this.lastKeyFrameMs < 0L) {
            this.lastKeyFrameMs = l2;
        }
        boolean bl2 = false;
        if (!bl && this.forcedKeyFrameMs > 0L && l2 > this.lastKeyFrameMs + this.forcedKeyFrameMs) {
            bl2 = true;
        }
        if (bl || bl2) {
            if (bl) {
                Log.d((String)TAG, (String)"Sync frame request");
            } else {
                Log.d((String)TAG, (String)"Sync frame forced");
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.mediaCodec.setParameters(bundle);
            this.lastKeyFrameMs = l2;
        }
    }

    boolean encodeBuffer(boolean bl, int n, int n2, long l) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l);
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            Log.e((String)TAG, (String)"encodeBuffer failed", (Throwable)illegalStateException);
            return false;
        }
    }

    boolean encodeTexture(boolean bl, int n, float[] fArray, long l) {
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l);
            return true;
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)TAG, (String)"encodeTexture failed", (Throwable)runtimeException);
            return false;
        }
    }

    void signalEOS() {
        if (this.mediaCodec == null) {
            return;
        }
        if (this.inputSurface != null) {
            this.mediaCodec.signalEndOfInputStream();
        } else {
            int n = this.dequeueInputBuffer();
            while (n == -1) {
                try {
                    Thread.sleep(100L);
                    n = this.dequeueInputBuffer();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (n >= 0) {
                this.mediaCodec.queueInputBuffer(n, 0, 0, 0L, 4);
            }
        }
    }

    void release() {
        if (this.mediaCodecThread == null) {
            return;
        }
        Log.d((String)TAG, (String)"Java releaseEncoder");
        this.checkOnMediaCodecThread();
        if (this.mediaCodec != null) {
            if (this.inputSurface != null) {
                this.inputSurface.release();
                this.inputSurface = null;
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.d((String)MediaCodecVideoEncoder.TAG, (String)"Java releaseEncoder on release thread");
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                        MediaCodecVideoEncoder.this.mediaCodec = null;
                        Log.d((String)MediaCodecVideoEncoder.TAG, (String)"Java releaseEncoder on release thread done");
                    }
                    catch (Exception exception) {
                        Log.e((String)MediaCodecVideoEncoder.TAG, (String)"Media encoder release failed", (Throwable)exception);
                    }
                    countDownLatch.countDown();
                }
            };
            new Thread(runnable).start();
            if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
                Log.e((String)TAG, (String)"Media encoder release timeout");
                ++codecErrors;
                if (errorCallback != null) {
                    Log.e((String)TAG, (String)("Invoke codec error callback. Errors: " + codecErrors));
                    errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
                }
            }
        }
        this.mediaCodecThread = null;
        runningInstance = null;
        Log.d((String)TAG, (String)"Java releaseEncoder done");
    }

    private boolean setRates(int n, int n2) {
        this.checkOnMediaCodecThread();
        int n3 = n;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            this.bitrateAccumulatorMax = (double)n3 / 8.0;
            if (this.targetBitrateBps > 0 && n3 < this.targetBitrateBps) {
                this.bitrateAccumulator = this.bitrateAccumulator * (double)n3 / (double)this.targetBitrateBps;
            }
        }
        this.targetBitrateBps = n3;
        this.targetFps = n2;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && this.targetFps > 0) {
            n3 = this.originFps * this.targetBitrateBps / this.targetFps;
            Log.v((String)TAG, (String)("setRates: " + n / 1000 + " -> " + n3 / 1000 + " kbps. Fps: " + this.targetFps));
        } else if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            Log.v((String)TAG, (String)("setRates: " + n / 1000 + " kbps. Fps: " + this.targetFps + ". ExpScale: " + this.bitrateAdjustmentScaleExp));
            if (this.bitrateAdjustmentScaleExp != 0) {
                n3 = (int)((double)n3 * this.getBitrateScale(this.bitrateAdjustmentScaleExp));
            }
        } else {
            Log.v((String)TAG, (String)("setRates: " + n / 1000 + " kbps. Fps: " + this.targetFps));
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", n3);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"setRates failed", (Throwable)illegalStateException);
            return false;
        }
    }

    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)("dequeueIntputBuffer failed" + illegalStateException.getMessage()));
            return -2;
        }
    }

    @TargetApi(value=21)
    ByteBuffer getByteBuffer(boolean bl, int n) {
        int n2 = Build.VERSION.SDK_INT;
        ByteBuffer byteBuffer = n2 >= 21 ? (bl ? this.mediaCodec.getInputBuffer(n) : this.mediaCodec.getOutputBuffer(n)) : (bl ? this.inputBuffers[n] : this.outputBuffers[n]);
        return byteBuffer;
    }

    OutputBufferInfo dequeueOutputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n >= 0) {
                boolean bl;
                boolean bl2 = bl = (bufferInfo.flags & 2) != 0;
                if (bl) {
                    Log.d((String)TAG, (String)("Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size));
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    ByteBuffer byteBuffer = this.getByteBuffer(false, n);
                    byteBuffer.position(bufferInfo.offset);
                    byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(byteBuffer);
                    this.mediaCodec.releaseOutputBuffer(n, false);
                    n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
            }
            if (n >= 0) {
                ByteBuffer byteBuffer = this.getByteBuffer(false, n).duplicate();
                byteBuffer.position(bufferInfo.offset);
                byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                this.reportEncodedFrame(bufferInfo.size);
                boolean bl = (bufferInfo.flags & 1) != 0;
                return new OutputBufferInfo(n, byteBuffer.slice(), bufferInfo.size, bl, bufferInfo.presentationTimeUs);
            }
            if (n == -3) {
                if (Build.VERSION.SDK_INT < 21) {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                }
                return this.dequeueOutputBuffer();
            }
            if (n == -2) {
                return this.dequeueOutputBuffer();
            }
            if (n == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + n);
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"dequeueOutputBuffer failed", (Throwable)illegalStateException);
            return new OutputBufferInfo(-1, null, -1, false, -1L);
        }
    }

    private double getBitrateScale(int n) {
        return Math.pow(2.0, (double)n / 10.0);
    }

    private void reportEncodedFrame(int n) {
        if (this.targetFps == 0 || this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            return;
        }
        double d = (double)this.targetBitrateBps / (8.0 * (double)this.targetFps);
        this.bitrateAccumulator += (double)n - d;
        this.bitrateObservationTimeMs += 1000.0 / (double)this.targetFps;
        double d2 = 3.0 * this.bitrateAccumulatorMax;
        this.bitrateAccumulator = Math.min(this.bitrateAccumulator, d2);
        this.bitrateAccumulator = Math.max(this.bitrateAccumulator, -d2);
        if (this.bitrateObservationTimeMs > 3000.0) {
            Log.d((String)TAG, (String)("Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp));
            boolean bl = false;
            if (this.bitrateAccumulator > this.bitrateAccumulatorMax) {
                int n2 = (int)(this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp -= n2;
                this.bitrateAccumulator = this.bitrateAccumulatorMax;
                bl = true;
            } else if (this.bitrateAccumulator < -this.bitrateAccumulatorMax) {
                int n3 = (int)(-this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp += n3;
                this.bitrateAccumulator = -this.bitrateAccumulatorMax;
                bl = true;
            }
            if (bl) {
                this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 10);
                this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -10);
                Log.d((String)TAG, (String)("Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + this.getBitrateScale(this.bitrateAdjustmentScaleExp)));
                this.setRates(this.targetBitrateBps / 1000, this.targetFps);
            }
            this.bitrateObservationTimeMs = 0.0;
        }
    }

    boolean releaseOutputBuffer(int n) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)TAG, (String)"releaseOutputBuffer failed", (Throwable)illegalStateException);
            return false;
        }
    }

    @TargetApi(value=21)
    VImage getImage(int n) {
        Image image = this.mediaCodec.getInputImage(n);
        Image.Plane[] planeArray = image.getPlanes();
        this.cacheImage.yBuffer = planeArray[0].getBuffer();
        this.cacheImage.yStride = planeArray[0].getRowStride();
        this.cacheImage.uBuffer = planeArray[1].getBuffer();
        this.cacheImage.uStride = planeArray[1].getRowStride();
        this.cacheImage.vBuffer = planeArray[2].getBuffer();
        this.cacheImage.vStride = planeArray[2].getRowStride();
        if (planeArray[1].getPixelStride() == 1 && planeArray[2].getPixelStride() == 1) {
            this.cacheImage.isI420 = true;
        } else {
            this.cacheImage.isI420 = false;
        }
        return this.cacheImage;
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final int size;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n, ByteBuffer byteBuffer, int n2, boolean bl, long l) {
            this.index = n;
            this.buffer = byteBuffer;
            this.size = n2;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l;
        }
    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final boolean supportedCBR;
        public final boolean supportedProfile;

        public EncoderProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType, boolean bl, boolean bl2) {
            this.codecName = string;
            this.colorFormat = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.supportedCBR = bl;
            this.supportedProfile = bl2;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    private static class VImage {
        private boolean isI420;
        private ByteBuffer yBuffer;
        private ByteBuffer uBuffer;
        private ByteBuffer vBuffer;
        private int yStride;
        private int uStride;
        private int vStride;

        private VImage() {
        }
    }

    private static class MediaCodecProperties {
        public final String codecPrefix;
        public final int minSdk;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        MediaCodecProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecPrefix = string;
            this.minSdk = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    public static enum VideoCodecType {
        VIDEO_CODEC_H264_AVC,
        VIDEO_CODEC_H264_AVC_MULTILAYER,
        VIDEO_CODEC_H265,
        VIDEO_CODEC_VP8;

    }
}

