package im.zego.zegoexpress.internal;

import android.app.Application;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import android.os.*;

import im.zego.zegoexpress.ZegoExpressEngine;
import im.zego.zegoexpress.ZegoExpressErrorCode;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.entity.*;
import im.zego.zegoexpress.utils.*;

import java.nio.*;
import java.util.*;

import static im.zego.zegoexpress.ZegoExpressErrorCode.CommonEventHandlerExists;

public class ZegoExpressEngineInternalImpl extends ZegoExpressEngine {
    public static Handler mUIHandler;
    static private volatile boolean hasSoLoaded;
    private static volatile ZegoExpressEngine engine = null;
    private static Application context;
    private static boolean mIsTestEnv = true;
    private static boolean enableToastOnTestEnv = true;
    private static boolean enableDebugErrorAlways = false;

    private static ZegoLanguage language = ZegoLanguage.ENGLISH;
    public static IZegoEventHandler eventHandler = null;
    public static IZegoCustomAudioProcessHandler iZegoCustomAudioProcessHandler = null;
    public static HashMap<Integer, IZegoRoomSetRoomExtraInfoCallback> sRoomSetExtraInfoHandler = new HashMap<>();
    public static HashMap<Integer, IZegoPublisherUpdateCdnUrlCallback> sPublisherUpdateCDNURLHandler = new HashMap<>();
    public static HashMap<Integer, IZegoPublisherSetStreamExtraInfoCallback> sPublisherUpdateStreamExtraInfoHandler = new HashMap<>();
    public static HashMap<Integer, IZegoIMSendBarrageMessageCallback> sIMSendBarragetMssageHandler = new HashMap<>();

    public static HashMap<Integer, IZegoMixerStartCallback> sMixerStartResultHandler = new HashMap<>();
    public static HashMap<Integer, IZegoMixerStopCallback> sMixerStopResultHandler = new HashMap<>();
    public static HashMap<Integer, IZegoIMSendBroadcastMessageCallback> sIMSendBoradcastMssageHandler = new HashMap<>();
    public static HashMap<Integer, IZegoIMSendCustomCommandCallback> sIMSendCustomCommandHandler = new HashMap<>();

    public static HashMap<Integer, IZegoRoomSendReliableMessageCallback> sRoomSendReliableMessageResultHandler = new HashMap<>();
    public static HashMap<Integer, IZegoRoomGetReliableMessageCallback> sRoomGetReliableMessageResultHandler = new HashMap<>();
    public static HashMap<Integer,IZegoPublisherTakeSnapshotCallback> sPublisherTakeSnapshotResultHandler =new HashMap<>();
    public static HashMap<String,IZegoPlayerTakeSnapshotCallback> sPlayerTakeSnapshotResultHandler =new HashMap<>();
    public static HashMap<Integer,IZegoTestNetworkConnectivityCallback> sTestNetworkConnectivityHandler = new HashMap<>();
    public void setCustomAudioProcessHandler(IZegoCustomAudioProcessHandler handler) {
        iZegoCustomAudioProcessHandler = handler;
    }

    final public static class ZegoInnerModule {
        public static final int COMMON = 0;
        public static final int ENGINE = 1;
        public static final int ROOM = 2;
        public static final int PUBLISHER = 3;
        public static final int PLAYER = 4;
        public static final int MIXER = 5;
        public static final int DEVICE = 6;
        public static final int PREPROCESS = 7;
        public static final int MEDIAPLAYER = 8;
        public static final int IM = 9;
        public static final int RECODER = 10;
        public static final int CUSTOM_VIDEO_IO = 11;
        public static final int CUSTOM_AUDIO_IO = 12;
        public static final int AUDIO_EFFECT_PLAYER = 14;
        public static final int UTILITIES = 15;
    }

    private static final int MAX_EVENT_HANDLE_COUNT = 16;
    private static final int ZEGO_EXPRESS_MODULE_JNI = 0xc;
    private static final int RESERVE_SEGMENT = 1000000;
    private static final int ERRCODE_OFFSET = 1000;
    private static final int ZEGO_ERRCODE_SUCCESS = 0x0;
    private static final int ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED = RESERVE_SEGMENT + ZegoInnerModule.COMMON * ERRCODE_OFFSET + 1;
    private static final int ZEGO_ERRCODE_ENGINE_APPID_ZERO = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET + 1;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET + 2;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_NULL = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET + 3;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET + 27;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED = RESERVE_SEGMENT + ZegoInnerModule.ENGINE * ERRCODE_OFFSET + 28;


    public static Object mCustomVideoRenderHandler;

    public static IZegoDestroyCompletionCallback iZegoDestroyCompletionCallback;

    public static Object mCustomVideoCaptureHandler;

    public static IZegoAudioMixingHandler iZegoAudioMixingHandler;

    public static IZegoAudioDataHandler iZegoAudioDataHandler;

    public static IZegoDataRecordEventHandler iZegoDataRecordEventHandler;


    static {
        try {
            System.loadLibrary("ZegoExpressEngine");
            hasSoLoaded = true;
        } catch (UnsatisfiedLinkError e) {
            //Log.e("ZEGO", "load ZegoExpressSDK native library failed", e);
            hasSoLoaded = false;
        }
    }

    //TODO 该接口需要做单元测试
    static boolean ensureSoLoaded(Context appContext, String customizeSoPath) {
        if (!hasSoLoaded) {
            //优先加载外部指定的so
            if (!TextUtils.isEmpty(customizeSoPath)) {
                try {
                    hasSoLoaded = ZegoLibraryLoadUtil.loadSpecialLibrary(customizeSoPath, appContext);
                } catch (UnsatisfiedLinkError e) {
                    Log.e("ZEGO", String.format("Load library %s failed", customizeSoPath), e);
                    return false;
                } catch (Exception e) {
                    Log.e("ZEGO", String.format("Load library %s failed", customizeSoPath), e);
                    return false;
                }
            }
        }

        if (!hasSoLoaded) {
            //当加载外部指定so失败时，指定库文件重新加载
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSoFile("libZegoExpressSDK.so", appContext);
                return hasSoLoaded;
            } catch (UnsatisfiedLinkError e) {
                Log.e("ZEGO", "Load library libZegoExpressSDK.so failed", e);
                return false;
            }
        }
        return true;
    }


    private static im.zego.zegoexpress.entity.ZegoEngineConfig mEngineConfig;

    public static void setEngineConfig(ZegoEngineConfig engineConfig) {
        if (engineConfig != null) {
            // 如果外层未设置 engineConfig , 桥接层应new一份实例，传到jni
            if (engineConfig.advancedConfig != null) {
                if (engineConfig.advancedConfig.containsKey("enable_toast_on_test_env")) {
                    String enableToastOnTestEnvStr = engineConfig.advancedConfig.get("enable_toast_on_test_env");
                    if (enableToastOnTestEnvStr != null) {
                        enableToastOnTestEnv = !enableToastOnTestEnvStr.equals("false");
                    }
                }
                if (engineConfig.advancedConfig.containsKey("enable_debug_error_always")) {
                    String enableDebugErrorAlwaysStr = engineConfig.advancedConfig.get("enable_debug_error_always");
                    if (enableDebugErrorAlwaysStr != null) {
                        enableDebugErrorAlways = !enableDebugErrorAlwaysStr.equals("false");
                    }
                }
            }
            mEngineConfig = engineConfig;
        } else {
            mEngineConfig = new ZegoEngineConfig();
        }

        String advanceConfig = "";
        if (mEngineConfig.advancedConfig != null) {
            for (String key : mEngineConfig.advancedConfig.keySet()) {
                advanceConfig += key + "=" + mEngineConfig.advancedConfig.get(key) + ";";
            }
        }

        // 当App层设置了 customVideoRenderConfig , 说明开启了外部渲染
        // 由于jni层处理字段为枚举类型的对象时不方便, 这里转为基础类型来向jni传参
        boolean engineConfig_enableCustomVideoRender;
        boolean engineConfig_isEngineRender;
        int engineConfig_zegoCustomVideoRenderSeries;
        int engineConfig_zegoCustomVideoRenderType;
        if (mEngineConfig.customVideoRenderConfig != null) {
            engineConfig_enableCustomVideoRender = true;
            engineConfig_zegoCustomVideoRenderSeries = mEngineConfig.customVideoRenderConfig.frameFormatSeries.value();
            engineConfig_isEngineRender = mEngineConfig.customVideoRenderConfig.enableEngineRender;
            engineConfig_zegoCustomVideoRenderType = mEngineConfig.customVideoRenderConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoRender = false;
            engineConfig_isEngineRender = false;
            engineConfig_zegoCustomVideoRenderSeries = -1;
            engineConfig_zegoCustomVideoRenderType = -1;
        }

        // 当App层设置了 videoCaptureConfig , 说明开启了外部采集
        // 由于jni层处理字段为枚举类型的对象时不方便, 这里转为基础类型来向jni传参
        boolean engineConfig_enableCustomVideoCaptureMain;
        int engineConfig_zegoCustomVideoCaptureMainType;
        if (mEngineConfig.customVideoCaptureMainConfig != null) {
            engineConfig_enableCustomVideoCaptureMain = true;
            engineConfig_zegoCustomVideoCaptureMainType = mEngineConfig.customVideoCaptureMainConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoCaptureMain = false;
            engineConfig_zegoCustomVideoCaptureMainType = -1;
        }

        boolean engineConfig_enableCustomVideoCaptureAux;
        int engineConfig_zegoCustomVideoCaptureAuxType;

        if (mEngineConfig.customVideoCaptureAuxConfig != null) {
            engineConfig_enableCustomVideoCaptureAux = true;
            engineConfig_zegoCustomVideoCaptureAuxType = mEngineConfig.customVideoCaptureAuxConfig.bufferType.value();
        } else {
            engineConfig_enableCustomVideoCaptureAux = false;
            engineConfig_zegoCustomVideoCaptureAuxType = -1;
        }

//        try {
//            final Context mContext = context;
//            if (ZegoExpressEngineJni.engineConfig.logConfig.logPath.equals("") && mContext != null) {
//                ZegoExpressEngineJni.engineConfig.logConfig.logPath = ZegoLogUtil.getLogPath(mContext);
//            }
//        } catch (Exception ex) {
//            switch (language) {
//                case ENGLISH:
//                    throw new RuntimeException("Input application parameter abnormal");
//                case CHINESE:
//                    throw new RuntimeException("输入application参数异常");
//            }
//        }

        ZegoExpressEngineJniAPI.setEngineInitConfigToJni(mEngineConfig,
                engineConfig_enableCustomVideoRender, engineConfig_zegoCustomVideoRenderSeries,
                engineConfig_isEngineRender, engineConfig_zegoCustomVideoRenderType,
                engineConfig_enableCustomVideoCaptureMain, engineConfig_zegoCustomVideoCaptureMainType,
                engineConfig_enableCustomVideoCaptureAux, engineConfig_zegoCustomVideoCaptureAuxType,
                mEngineConfig.logConfig.logPath, mEngineConfig.logConfig.logSize,
                advanceConfig);


    }


    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnvironment,
                                                 ZegoScenario scenario, Application application, IZegoEventHandler handler) {
        synchronized (ZegoExpressEngineInternalImpl.class) {
            // 防止多次调用在Java层产生多份实例
            if (engine != null) {
                return engine;
            }

            // 防止 application 参数传空
            if (application == null) {
                switch (language) {
                    case ENGLISH:
                        throw new RuntimeException("Input application parameter abnormal");
                    case CHINESE:
                        throw new RuntimeException("输入application参数异常");
                }
            }
            // setEngineConfig();

            int errorCode = ZegoExpressEngineJniAPI.engineInitJni(appID, appSign, isTestEnvironment, scenario.value(), application);

            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.COMMON, "createEngine", errorCode);
            if (errorCode != 0) {
                return null;
            } else {

                mUIHandler = new Handler(Looper.getMainLooper());
                context = application;
                mIsTestEnv = isTestEnvironment;
                engine = new ZegoExpressEngineInternalImpl();
                if (handler != null) {
                    engine.setEventHandler(handler);
                }
                return engine;
            }
        }

    }


    public static ZegoExpressEngine getEngine() {
        return engine;
    }

    public ZegoAudioConfig getAudioConfig() {
        return ZegoExpressEngineJniAPI.getAudioConfigJni();
    }

    @Override
    public void setPublishStreamEncryptionKey(String key) {
        setPublishStreamEncryptionKey(key, ZegoPublishChannel.MAIN);
    }

    @Override
    public void setPublishStreamEncryptionKey(String key, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setPublishStreamEncryptionKeyJni(key, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setPublishStreamEncryptionKey", errorCode);
    }


    public void takePublishStreamSnapshot(IZegoPublisherTakeSnapshotCallback callback) {
       takePublishStreamSnapshot(callback,ZegoPublishChannel.MAIN);
    }


    public void takePublishStreamSnapshot(IZegoPublisherTakeSnapshotCallback callback, ZegoPublishChannel channel) {
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherTakeSnapshotResultHandler.put(channel.value(), callback);
        }
        int errorCode = ZegoExpressEngineJniAPI.takePublishStreamSnapshotJni(channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "takePublishStreamSnapshot", errorCode);

    }

    @Override
    public void mutePublishStreamAudio(boolean mute) {
        mutePublishStreamAudio(mute, ZegoPublishChannel.MAIN);
    }

    public ZegoVideoConfig getVideoConfig(ZegoPublishChannel main) {
        return ZegoExpressEngineJniAPI.getVideoConfigJni(main.value());
    }


    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode) {
        setVideoMirrorMode(mirrorMode, ZegoPublishChannel.MAIN);
    }

    public static void destroyEngine(final IZegoDestroyCompletionCallback callback) {
        synchronized (ZegoExpressEngineInternalImpl.class) {
            if (engine != null) {
                iZegoDestroyCompletionCallback = callback;
                ((ZegoExpressEngineInternalImpl) engine).release();
                int errorCode = ZegoExpressEngineJniAPI.engineUninitAsyncJni();
            } else {
                if (iZegoDestroyCompletionCallback != null) {
                    iZegoDestroyCompletionCallback.onDestroyCompletion();
                }
            }
        }
    }

    public void setEventHandler(IZegoEventHandler handler) {
        int errorCode = ZEGO_ERRCODE_SUCCESS;
        synchronized (ZegoExpressEngineInternalImpl.class) {
            if (engine == null) {
                errorCode = ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED;
            } else {
                if (eventHandler != null && handler != null) {
                    errorCode = CommonEventHandlerExists;
                    printDebugInfo(ZegoDebugLevel.ERROR, ZegoInnerModule.ENGINE, "setEventHandler", CommonEventHandlerExists);
                } else {
                    eventHandler = handler;
                }
            }
        }
    }


    private void release() {
        eventHandler = null;
        if (sRoomSetExtraInfoHandler != null) {
            sRoomSetExtraInfoHandler.clear();
        }
        if (sPublisherUpdateCDNURLHandler != null) {
            sPublisherUpdateCDNURLHandler.clear();
        }
        if (sPublisherUpdateStreamExtraInfoHandler != null) {
            sPublisherUpdateStreamExtraInfoHandler.clear();
        }
        if (sMixerStartResultHandler != null) {
            sMixerStartResultHandler.clear();
        }

        if (sMixerStopResultHandler != null) {
            sMixerStopResultHandler.clear();
        }

        if (sIMSendBoradcastMssageHandler != null) {
            sIMSendBoradcastMssageHandler.clear();
        }
        if (sIMSendCustomCommandHandler != null) {
            sIMSendCustomCommandHandler.clear();
        }
        if (sIMSendBarragetMssageHandler != null) {
            sIMSendBarragetMssageHandler.clear();
        }
        if(sPublisherTakeSnapshotResultHandler!=null){
            sPublisherTakeSnapshotResultHandler.clear();
        }
        if(sPlayerTakeSnapshotResultHandler!=null){
            sPlayerTakeSnapshotResultHandler.clear();
        }
        if(sTestNetworkConnectivityHandler!=null){
            sTestNetworkConnectivityHandler.clear();
        }

        iZegoAudioMixingHandler = null;
        iZegoAudioDataHandler = null;
        mCustomVideoRenderHandler = null;
        mCustomVideoCaptureHandler = null;
        iZegoDataRecordEventHandler = null;

        context = null;
        engine = null;
        mIsTestEnv = true;
        mUIHandler = null;
        language = ZegoLanguage.ENGLISH;

        // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
        ZegoMediaPlayerInternalImpl.destroyAllMediaPlayer();

        // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

        setCustomVideoCaptureHandler(null);
        setCustomVideoRenderHandler(null);
        setCustomAudioProcessHandler(null);

    }


    public static String getVersion() {
        return ZegoExpressEngineJniAPI.getVersionJni();
    }

    public void setDebugVerbose(boolean enable, ZegoLanguage language) {
        language = language;
        ZegoExpressEngineJniAPI.setDebugVerboseJni(enable, language.value());
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ENGINE,
                "setDebugVerbose", ZEGO_ERRCODE_SUCCESS);
    }


    public void loginRoom(String roomID, ZegoUser user) {
        loginRoom(roomID, user, null);
    }

    public void uploadLog() {
        ZegoExpressEngineJniAPI.uploadLogJni();
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.ENGINE,
                "uploadLog", ZEGO_ERRCODE_SUCCESS);
    }


    public void loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {

        if (roomID == null) {
            roomID = "";
        }

        int errorCode = ZegoExpressEngineJniAPI.loginRoomJni(user, roomID, config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ROOM, "loginRoom", errorCode);
    }

    public void loginMultiRoom(String roomID, ZegoRoomConfig config) {
        if (roomID == null) {
            roomID = "";
        }

        int errorCode = ZegoExpressEngineJniAPI.loginMultiRoomJni(roomID, config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ROOM, "loginMultiRoom", errorCode);
    }

    public void loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config, String token) {
        int errorCode = ZegoExpressEngineJniAPI.loginRoomJni(user, roomID, config, token);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ROOM, "loginRoom", errorCode);
    }

    public void sendReliableMessage(String roomID, String msgType, String content, int latestSeq, IZegoRoomSendReliableMessageCallback callback) {
        int seq = ZegoExpressEngineJniAPI.sendReliableMessageJni(roomID, msgType, content, latestSeq);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sRoomSendReliableMessageResultHandler.put(seq, callback);
        }
    }

    public void getReliableMessage(String roomID, String msgType, IZegoRoomGetReliableMessageCallback callback) {
        int seq = ZegoExpressEngineJniAPI.getReliableMessageJni(roomID, msgType);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sRoomGetReliableMessageResultHandler.put(seq, callback);
        }
    }


    public void startPublishingStream(String streamID) {
        startPublishingStream(streamID, ZegoPublishChannel.MAIN);
    }

    public boolean isMicrophoneMuted() {
        return ZegoExpressEngineJniAPI.isMicrophoneMutedJni();
    }

    public boolean isSpeakerMuted() {
        return ZegoExpressEngineJniAPI.isSpeakerMutedJni();
    }

    public void enableHeadphoneMonitor(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHeadphoneMonitorJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "enableHeadphoneMonitor", errorCode);
    }

    public void enableAudioDataCallback(boolean enable, int callbackBitMask, ZegoAudioFrameParam param) {
        // 防止如果传空则使用默认参数
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        int errorCode = ZegoExpressEngineJniAPI.enableAudioDataCallbackJni(enable, callbackBitMask, param.sampleRate.value(), param.channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.CUSTOM_AUDIO_IO, "enablePlaybackAudioData", errorCode);
    }

    public void enableVirtualStereo(boolean enable, int angle) {
        int errorCode = ZegoExpressEngineJniAPI.enableVirtualStereoJni(enable, angle);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "enableVirtualStereo", errorCode);
    }

    public void setAudioEqualizerGain(int bandIndex, float bandGain) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioEqualizerGainJni(bandIndex, bandGain);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setAudioEqualizerGain", errorCode);
    }

    @Override
    public void setVoiceChangerPreset(ZegoVoiceChangerPreset preset) {
        int errorCode = ZegoExpressEngineJniAPI.setVoiceChangerPresetJni(preset.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setVoiceChangerPreset", errorCode);
    }

    public void setVoiceChangerParam(ZegoVoiceChangerParam param) {
        int errorCode;
        if (param != null) {
            errorCode = ZegoExpressEngineJniAPI.setVoiceChangerParamJni(param.pitch);
        } else {
            errorCode = ZegoExpressErrorCode.PreprocessVoiceChangerParamNull;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setVoiceChangerParam", errorCode);
    }

    @Override
    public void setReverbPreset(ZegoReverbPreset preset) {
        int errorCode = ZegoExpressEngineJniAPI.setReverbPresetJni(preset.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setReverbPreset", errorCode);
    }

    public void setReverbParam(ZegoReverbParam param) {
        int errorCode;
        if (param != null) {
            errorCode = ZegoExpressEngineJniAPI.setReverbParamJni(param.damping, param.dryWetRatio, param.reverberance, param.roomSize);
        } else {
            errorCode = ZegoExpressErrorCode.PreprocessReverbParamNull;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setVoiceChangerParam", errorCode);
    }

    public  void setReverbAdvancedParam(ZegoReverbAdvancedParam param){
        int errorCode;
        if (param != null) {
            errorCode = ZegoExpressEngineJniAPI.setReverbAdvancedParam(param.roomSize,param.reverberance,param.damping,param.wetOnly,param.wetGain,param.dryGain,param.toneLow,param.toneHigh,param.preDelay,param.stereoWidth);
        } else {
            errorCode = ZegoExpressErrorCode.PreprocessReverbParamNull;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setReverbAdvancedParam", errorCode);

    }


    @Override
    public void setReverbEchoParam(ZegoReverbEchoParam param) {
        int errorCode;
        if (param != null) {
            errorCode = ZegoExpressEngineJniAPI.setReverbEchoParamJni(param);
        } else {
            errorCode = ZegoExpressErrorCode.PreprocessReverbEchoParamNull;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setReverbEchoParam", errorCode);
    }

    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableCustomVideoCaptureJni(enable, config, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "enableHeadphoneMonitor", errorCode);
    }


    public void enableCustomVideoRender(boolean enable, ZegoCustomVideoRenderConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.enableCustomVideoRenderJni(enable, config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "enableCustomVideoRender", errorCode);
    }


    public void setHeadphoneMonitorVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setHeadphoneMonitorVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "setHeadphoneMonitorVolume", errorCode);
    }

    public void logoutRoom(String roomID) {
        int errorCode = ZegoExpressEngineJniAPI.logoutRoomJni(roomID);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ROOM, "logoutRoom", errorCode);
    }


    public void switchRoom(String fromRoomID, String toRoomID) {
        switchRoom(fromRoomID, toRoomID, null);

    }


    public void switchRoom(String fromRoomID, String toRoomID, ZegoRoomConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.switchRoomJni(fromRoomID, toRoomID, config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ROOM, "switchRoomJni", errorCode);
    }

    public void setRoomExtraInfo(String roomID, String key, String value, IZegoRoomSetRoomExtraInfoCallback callback) {
        int seq = ZegoExpressEngineJniAPI.setRoomExtraInfoJni(roomID, key, value);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sRoomSetExtraInfoHandler.put(seq, callback);
        }
    }

    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode, ZegoPublishChannel channel) {
        int errorCode;
        if (mirrorMode == null) {
            errorCode = ZegoExpressEngineJniAPI.ZegoVideoMirrorModeJni(ZegoVideoMirrorMode.ONLY_PREVIEW_MIRROR.value(), channel.value());
        } else {
            errorCode = ZegoExpressEngineJniAPI.ZegoVideoMirrorModeJni(mirrorMode.value(), channel.value());
        }

        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setVideoMirrorMode", errorCode);
    }


    public void setAppOrientation(ZegoOrientation orientation) {
        setAppOrientation(orientation, ZegoPublishChannel.MAIN);
    }

    public void setAppOrientation(ZegoOrientation orientation, ZegoPublishChannel channel) {
        int errorCode;
        if (orientation == null) {
            errorCode = ZegoExpressEngineJniAPI.setAppOrientationJni(ZegoOrientation.ORIENTATION_0.value(), channel.value());
        } else {
            errorCode = ZegoExpressEngineJniAPI.setAppOrientationJni(orientation.value(), channel.value());
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setAppOrientation", errorCode);
    }


    public void startPreview(ZegoCanvas canvas, ZegoPublishChannel channel) {
        int errorCode;
        if (canvas == null) {
            errorCode = ZegoExpressEngineJniAPI.startPreviewJni(null, ZegoViewMode.ASPECT_FILL.value(), 0, channel.value());
        } else if (canvas.viewMode == null) {
            errorCode = ZegoExpressEngineJniAPI.startPreviewJni(canvas.view, ZegoViewMode.ASPECT_FILL.value(), canvas.backgroundColor, channel.value());
        } else {
            errorCode = ZegoExpressEngineJniAPI.startPreviewJni(canvas.view, canvas.viewMode.value(), canvas.backgroundColor, channel.value());
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "startPreview", errorCode);
    }


    public void startPreview() {
        startPreview(null, ZegoPublishChannel.MAIN);
    }


    public void stopPreview() {
        stopPreview(ZegoPublishChannel.MAIN);
    }

    public void stopPreview(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopPreviewJni(channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "stopPreview", errorCode);
    }


    public void setVideoConfig(ZegoVideoConfig config) {
        setVideoConfig(config, ZegoPublishChannel.MAIN);
    }

    public void setVideoConfig(ZegoVideoConfig videoConfig, ZegoPublishChannel channel) {
        ZegoVideoCodecID zegoVideoCodecID = ZegoVideoCodecID.DEFAULT;
        if (videoConfig != null && videoConfig.codecID != null) {
            zegoVideoCodecID = videoConfig.codecID;
        }
        int errorCode = ZegoExpressEngineJniAPI.setVideoConfigJni(videoConfig, channel.value(), zegoVideoCodecID.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setVideoConfig", errorCode);
    }


    public ZegoVideoConfig getVideoConfig() {
        return getVideoConfig(ZegoPublishChannel.MAIN);
    }

    public void startPublishingStream(String streamID, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.startPublishingStreamJni(streamID, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "startPublish", errorCode);

    }

    @Override
    public void stopPublishingStream() {
        stopPublishingStream(ZegoPublishChannel.MAIN);
    }

    public void stopPublishingStream(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopPublishingStreamJni(channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "stopPublishJni", errorCode);
    }


    public void setStreamExtraInfo(String extraInfo, IZegoPublisherSetStreamExtraInfoCallback callback) {
        setStreamExtraInfo(extraInfo, ZegoPublishChannel.MAIN, callback);
    }

    public void mutePublishStreamAudio(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.mutePublishStreamAudioJni(mute, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "mutePublishStreamAudio", errorCode);
    }


    public void mutePublishStreamVideo(boolean mute) {
        mutePublishStreamVideo(mute, ZegoPublishChannel.MAIN);
    }

    public void mutePublishStreamVideo(boolean mute, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.mutePublishStreamVideoJni(mute, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "mutePublishStreamVideo", errorCode);
    }

    public void setStreamExtraInfo(String extraInfo, ZegoPublishChannel channel, IZegoPublisherSetStreamExtraInfoCallback handler) {
        int seq = ZegoExpressEngineJniAPI.setStreamExtraInfoJni(extraInfo, channel.value());
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateStreamExtraInfoHandler.put(new Integer(seq), handler);
        }
    }


    public void startPreview(ZegoCanvas canvas) {
        startPreview(canvas, ZegoPublishChannel.MAIN);
    }

    public void setCaptureVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setCaptureVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setCaptureVolume", errorCode);
    }


    public void setAudioCaptureStereoMode(ZegoAudioCaptureStereoMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioCaptureStereoModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setAudioCaptureStereoMode", errorCode);
    }

    public void setAudioConfig(ZegoAudioConfig config) {
        int errorCode = 0;
        if (config != null) {
            errorCode = ZegoExpressEngineJniAPI.setAudioConfigJni(config.bitrate, config.channel.value(), config.codecID.value());
        } else {
            errorCode = ZegoExpressEngineJniAPI.setAudioConfigJni(-1, -1, -1);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setAudioConfig", errorCode);
    }


    public void enableTrafficControl(boolean enable, int controlTypeBitMask) {
        int errorCode = ZegoExpressEngineJniAPI.enableTrafficControlJni(enable, controlTypeBitMask);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableTrafficControl", errorCode);
    }

    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig zegoCDNConfig, ZegoPublishChannel channel) {
        ZegoExpressEngineJniAPI.enablePublishDirectToCDNJni(enable, zegoCDNConfig, channel.value());
    }


    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible) {
        setPublishWatermark(watermark, isPreviewVisible, ZegoPublishChannel.MAIN);
    }


    public void addPublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJniAPI.addPublishCdnUrlJni(streamID, targetURL);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
        }
    }

    public void removePublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback handler) {
        int seq = ZegoExpressEngineJniAPI.removePublishCdnUrlJni(streamID, targetURL);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
        }
    }


    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig config) {
        enablePublishDirectToCDN(enable, config, ZegoPublishChannel.MAIN);
    }

    public void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setCapturePipelineScaleModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setCapturePipelineScaleMode", errorCode);
    }


    public void startPlayingStream(String streamID, ZegoCanvas canvas) {
        startPlayingStream(streamID, canvas, null);
    }

    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setPublishWatermarkJni(watermark, isPreviewVisible, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setPublishWatermark", errorCode);
    }

    public void setSEIConfig(ZegoSEIConfig config) {
        int errorCode = ZegoExpressEngineJniAPI.setSEIConfigJni(config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setSEIConfig", errorCode);
    }


    public void sendSEI(byte[] data) {
        sendSEI(data, ZegoPublishChannel.MAIN);
    }

    public void enableHardwareEncoder(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHardwareEncoderJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableHardwareEncoder", errorCode);
    }

    public void enableDTX(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableDTXJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableDTX", errorCode);
    }

    public void enableVAD(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableVADJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableVAD", errorCode);
    }

    public void startPlayingStream(String streamID, ZegoCanvas canvas, ZegoPlayerConfig config) {
        //todo 后面让c层修改, 如果重复传入不同的view，会有什么影响？应该要提示用户或者帮客户换View

        int videoLayer = 99; // TODO: 废弃属性设为 99，防止默认值被设置
        if (config != null && config.videoLayer != null) {
            videoLayer = config.videoLayer.value();
        }

        ZegoCDNConfig zegoCDNConfig = null;
        if (config != null && config.cdnConfig != null) {
            zegoCDNConfig = config.cdnConfig;
        }

        int errorCode;
        if (canvas == null) {
            errorCode = ZegoExpressEngineJniAPI.startPlayingStreamJni(streamID, null, 0, 0, zegoCDNConfig, videoLayer);

        } else {
            errorCode = ZegoExpressEngineJniAPI.startPlayingStreamJni(streamID, canvas.view, canvas.viewMode == null ? ZegoViewMode.ASPECT_FIT.value() : canvas.viewMode.value(), canvas.backgroundColor, zegoCDNConfig, videoLayer);
        }

        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "startPlayingStream", errorCode);

    }


    public void startPlayingStream(String streamID) {
        startPlayingStream(streamID, null, null);
    }


    public void startPlayingStream(String streamID, ZegoPlayerConfig config) {
        startPlayingStream(streamID, null, config);
    }

    public void stopPlayingStream(String streamID) {
        int errorCode = ZegoExpressEngineJniAPI.stopPlayingStreamJni(streamID);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "stopPlayingStream", errorCode);
    }

    @Override
    public void setPlayStreamDecryptionKey(String streamID, String key) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamDecryptionKeyJni(streamID,key);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "setPlayStreamDecryptionKey", errorCode);
    }


    public void takePlayStreamSnapshot(String streamID, IZegoPlayerTakeSnapshotCallback callback) {
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sPlayerTakeSnapshotResultHandler.put(streamID, callback);
        }
        int errorCode = ZegoExpressEngineJniAPI.takePlayStreamSnapshotJni(streamID);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "takePlayStreamSnapshot", errorCode);
    }

    public void setPlayVolume(String streamID, int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayVolumeJni(streamID, volume);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "setPlayVolume", errorCode);
    }

    public void setPlayStreamVideoLayer(String streamID, ZegoPlayerVideoLayer videoLayer) {
        int errorCode = ZegoExpressEngineJniAPI.setPlayStreamVideoLayerJni(streamID, videoLayer.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "setPlayStreamVideoLayer", errorCode);
    }

    public void mutePlayStreamAudio(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.mutePlayStreamAudioJni(streamID, mute);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "mutePlayStreamAudio", errorCode);
    }

    public void mutePlayStreamVideo(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.mutePlayStreamVideoJni(streamID, mute);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "mutePlayStreamVideo", errorCode);
    }

    public void setMinVideoBitrateForTrafficControl(int bitrate, ZegoTrafficControlMinVideoBitrateMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setMinVideoBitrateForTrafficControlJni(bitrate, mode.value());
    }

    // opt_content_start: audio_or_video = video
    public void enableHardwareDecoder(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHardwareDecoderJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PLAYER, "enableHardwareDecoder", errorCode);
    }
    // opt_content_end: audio_or_video = video

    public void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback handler) {
        int seq = ZegoExpressEngineJniAPI.startMixerJni(task);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sMixerStartResultHandler.put(seq, handler);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MIXER, "startMixerTask", 0);
    }

    public void enableAudioMixing(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAudioMixingJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "enableAudioMixing", errorCode);
    }


    public void setAudioMixingHandler(IZegoAudioMixingHandler handler) {
        iZegoAudioMixingHandler = handler;
    }

    public void muteLocalAudioMixing(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteLocalAudioMixingJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "muteLocalAudioMixing", errorCode);
    }


    public void setAudioMixingVolume(int volume, ZegoVolumeType type) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioMixingVolumeJniWithType(volume, type.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "setAudioMixingVolume", errorCode);
    }


    public void enableBeautify(int featureBitmask) {
        enableBeautify(featureBitmask, ZegoPublishChannel.MAIN);
    }

    public void setAudioMixingVolume(int volume) {
        int errorCode = ZegoExpressEngineJniAPI.setAudioMixingVolumeJni(volume);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.ENGINE, "setAudioMixingVolume", errorCode);
    }

    public void stopMixerTask(ZegoMixerTask task, IZegoMixerStopCallback handler) {
        int seq = ZegoExpressEngineJniAPI.stopMixerJni(task);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sMixerStopResultHandler.put(seq, handler);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MIXER, "stopMixerTask", 0);
    }

    public void muteMicrophone(boolean mute) {
        int errorCode = ZegoExpressEngineJniAPI.muteMicrophoneJni(mute);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "muteMicrophone", errorCode);
    }

    public void muteAudioOutput(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.muteAudioOutputJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "muteAudioOutput", errorCode);
    }

    public void muteSpeaker(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.muteSpeakerJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "muteSpeaker", errorCode);
    }

    // opt_content_start: audio_or_video = video
    public void enableCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableCameraJni(enable, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableCamera", errorCode);
    }


    public void useFrontCamera(boolean enable) {
        useFrontCamera(enable, ZegoPublishChannel.MAIN);
    }

    public void useFrontCamera(boolean enable, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.useFrontCameraJni(enable, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "useFrontCamera", errorCode);
    }

    public void setCameraZoomFactor(float factor) {
        setCameraZoomFactor(factor, ZegoPublishChannel.MAIN);
    }

    public void setCameraZoomFactor(float factor, ZegoPublishChannel channel) {
        int errorCode =  ZegoExpressEngineJniAPI.setCameraZoomFactorJni(factor, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "setCameraZoomFactor", errorCode);
    }

    public float getCameraMaxZoomFactor() {
        return getCameraMaxZoomFactor(ZegoPublishChannel.MAIN);
    }

    public float getCameraMaxZoomFactor(ZegoPublishChannel channel) {
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO,
                ZegoInnerModule.DEVICE, "getCameraMaxZoomFactor", 0);
        return ZegoExpressEngineJniAPI.getCameraMaxZoomFactorJni(channel.value());
    }
    // opt_content_end: audio_or_video = video

    public void startSoundLevelMonitor(int timeInMS) {
        int errorCode = ZegoExpressEngineJniAPI.startSoundLevelMonitorJni(timeInMS);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "startSoundLevelMonitor", errorCode);
    }

    public void startSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.startSoundLevelMonitorJni(100);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "startSoundLevelMonitor", errorCode);
    }

    public void stopSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopSoundLevelMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "stopSoundLevelMonitor", errorCode);
    }

    public void startAudioSpectrumMonitor() {
        startAudioSpectrumMonitor(100);
    }


    public void startAudioSpectrumMonitor(int timeInMS) {
        int errorCode = ZegoExpressEngineJniAPI.startFrequencySpectrumMonitorJni(timeInMS);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "startFrequencySpectrumMonitor", errorCode);
    }

    public void stopAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopFrequencySpectrumMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "stopFrequencySpectrumMonitor", errorCode);
    }

    @Override
    public void startPerformanceMonitor(int millisecond) {
        int errorCode = ZegoExpressEngineJniAPI.startPerformanceMonitorJni(millisecond);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "startPerformanceMonitor", errorCode);
    }

    @Override
    public void stopPerformanceMonitor() {
        int errorCode = ZegoExpressEngineJniAPI.stopPerformanceMonitorJni();
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "stopPerformanceMonitor", errorCode);
    }

    public void enableAudioCaptureDevice(boolean enable) {
        //todo 名称修改为audio
        int errorCode = ZegoExpressEngineJniAPI.enableAudioCaptureDeviceJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableCaptureDevice", errorCode);
    }

    public void enableAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAECJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableAEC", errorCode);
    }

    public void enableHeadphoneAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableHeadphoneAECJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "enableAECWhenHeadsetDetected", errorCode);
    }

    public void setAECMode(ZegoAECMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setAECModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setAECMode", errorCode);
    }

    // opt_content_start: audio_or_video = video
    public void enableCheckPoc(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableCheckPocJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableCheckPoc", errorCode);
    }
    // opt_content_end: audio_or_video = video

    public void enableAGC(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableAGCJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableAGC", errorCode);
    }

    public void enableANS(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableANSJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableANS", errorCode);
    }

    @Override
    public void enableTransientANS(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.enableTransientANSJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableTransientANS", errorCode);
    }

    public void setANSMode(ZegoANSMode mode) {
        int errorCode = ZegoExpressEngineJniAPI.setANSModeJni(mode.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PREPROCESS, "setANSMode", errorCode);
    }

    // opt_content_start: audio_or_video = video
    public void enableBeautify(int feature, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.enableBeautifyJni(feature, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "enableBeautify", errorCode);
    }


    public void setBeautifyOption(ZegoBeautifyOption option) {
        setBeautifyOption(option, ZegoPublishChannel.MAIN);
    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video
    public void setBeautifyOption(ZegoBeautifyOption option, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setBeautifyOptionJni(option, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "setBeautifyOption", errorCode);

    }
    // opt_content_end: audio_or_video = video

    // opt_content_start: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_SIDE_INFO
    public void sendSEI(byte[] data, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendSEIJni(data, channel.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.PUBLISHER, "sendSEI", errorCode);
    }
    // opt_content_end: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_SIDE_INFO

    public void sendBarrageMessage(String roomID, String message, IZegoIMSendBarrageMessageCallback handler) {
        int seq = ZegoExpressEngineJniAPI.sendBarrageMessageJni(roomID, message);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendBarragetMssageHandler.put(seq, handler);
        }
    }


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public ZegoMediaPlayer createMediaplayer() {
        return ZegoMediaPlayerInternalImpl.createMediaPlayer();
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    public void setCustomVideoRenderHandler(IZegoCustomVideoRenderHandler handler) {
        mCustomVideoRenderHandler = handler;
    }


    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config) {
        enableCustomVideoCapture(enable, config, ZegoPublishChannel.MAIN);
    }


    public void setCustomVideoCaptureHandler(IZegoCustomVideoCaptureHandler handler) {
        mCustomVideoCaptureHandler = handler;
    }


    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond) {
        sendCustomVideoCaptureRawData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }


    public static boolean isCustomVideoCapturing = false;


    public void sendBroadcastMessage(String roomID, String message, IZegoIMSendBroadcastMessageCallback callback) {
        int seq = ZegoExpressEngineJniAPI.sendBroadcastMessageJni(roomID, message);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendBoradcastMssageHandler.put(seq, callback);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.IM, "sendBroadcastMessage", 0);
    }

    public void sendCustomCommand(String roomID, String command, ArrayList<ZegoUser> toUserList, IZegoIMSendCustomCommandCallback callback) {

        int size = toUserList.size();
        ZegoUser[] userList = toUserList.toArray(new ZegoUser[size]);
        int seq = ZegoExpressEngineJniAPI.sendCustomerMessageJni(command, userList, roomID);
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sIMSendCustomCommandHandler.put(seq, callback);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.IM, "sendCustomCommand", 0);
    }

    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureRawDataJni(data, dataLength, params.format.value(), params.strides, params.width, params.height, referenceTimeMillisecond, channel.value(), params.rotation);
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_VIDEO_IO, "sendCustomVideoCaptureRawData", errorCode, false);
        }
    }


    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond) {
        sendCustomVideoCaptureTextureData(textureID, width, height, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }


    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureEncodedDataJni(data, dataLength, params.format.value(), params.isKeyFrame, params.width, params.height, params.SEIData, params.SEIDataLength, params.rotation, referenceTimeMillisecond, channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_VIDEO_IO, "sendCustomVideoCaptureEncodedData", errorCode, false);
        }
    }


    public void setCustomVideoCaptureFillMode(ZegoViewMode mode) {
        setCustomVideoCaptureFillMode(mode, ZegoPublishChannel.MAIN);
    }


    public void setCustomVideoCaptureFillMode(ZegoViewMode mode, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.setCustomVideoCaptureFillModeJni(mode.value(), channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_VIDEO_IO, "setCustomVideoCaptureFillMode", errorCode);
        }
    }


    public void setCustomVideoCaptureFlipMode(ZegoVideoFlipMode mode) {
        setCustomVideoCaptureFlipMode(mode, ZegoPublishChannel.MAIN);
    }


    public void setCustomVideoCaptureFlipMode(ZegoVideoFlipMode mode, ZegoPublishChannel channel) {
        ZegoExpressEngineJniAPI.setCustomVideoCaptureFlipModeJni(mode.value(), channel.value());
    }

    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond, ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.sendCustomVideoCaptureTextureDataJni(textureID, width, height, referenceTimeMillisecond, channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_VIDEO_IO, "sendCustomVideoCaptureTextureData", errorCode, false);
        }
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture() {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJniAPI.getCustomVideoCaptureSurfaceTextureJni(ZegoPublishChannel.MAIN.value());
        return surfaceTexture;
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture(ZegoPublishChannel channel) {
        SurfaceTexture surfaceTexture = ZegoExpressEngineJniAPI.getCustomVideoCaptureSurfaceTextureJni(channel.value());
        return surfaceTexture;
    }


    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond) {
        sendCustomVideoCaptureEncodedData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void setBuiltInSpeakerOn(boolean enable) {
        int errorCode = ZegoExpressEngineJniAPI.setBuiltInSpeakerOnJni(enable);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.DEVICE, "setBuiltInSpeakerOn", errorCode);
    }


    public void enableCamera(boolean enable) {
        enableCamera(enable, ZegoPublishChannel.MAIN);
    }


    // 输出调试信息重载接口，默认弹toast
    public static void printDebugInfo(ZegoDebugLevel level, int module, final String funcName, final int errorCode, Object... args) {
        printDebugInfoEx(level, module, funcName, errorCode, true, args);
    }

    /**
     * 输出调试信息
     * @param level 日志级别，根据调试信息打印不同等级日志
     * @param module 被调用的模块名称，方便开发定位问题
     * @param funcName 被调用的函数名称，方便开发定位问题
     * @param errorCode 接口调用错误码返回值
     * @param isToast 对于高频繁调用的接口来说，并不需要弹toast, 比如发送视频外部采集帧或音频帧之类的接口。
     * @param args  历史遗留的参数，目前没有用到，后续可以考虑干掉
     */
    public static void printDebugInfoEx(ZegoDebugLevel level, int module, final String funcName, final int errorCode, boolean isToast, Object... args) {

        final String msg;

        msg = ZegoExpressEngineJniAPI.printDebugInfoJni(level.value(), module, funcName, errorCode, args);

        if (!msg.equals("")) {
            if (errorCode == 0 || !mIsTestEnv) {
                //只有在测试环境下，才弹窗提示
            } else {
                if (enableToastOnTestEnv && isToast) {
                    ZegoExpressEngineJniAPI.showDebugMessageBoxJni(language.value(), errorCode, funcName, msg);
                }
            }

            if (errorCode != 0 || enableDebugErrorAlways) {
                if (mUIHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                }

                onDebugError(errorCode, funcName, msg);

            }
        }
    }


    public void setAudioDataHandler(IZegoAudioDataHandler handler) {
        iZegoAudioDataHandler = handler;
    }

    @Override
    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config) {
        enableCustomAudioIO(enable, config, ZegoPublishChannel.MAIN);
    }


    public static void showToastMsg(final String msg, final Context context) {
        //todo 是否有可能线程不安全
        if (context != null) {
            try {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
                } else {
                    final Handler uiHandler = mUIHandler;
                    uiHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
                        }
                    });
                }
            } catch (Exception e) {
                //do nothing
            }
        }
    }

    public static void onDebugError(final int errorCode, final String funcName, final String info) {
        final Handler uiHandler = mUIHandler;
        if (uiHandler == null) {
            //todo: 这里需要增加日志打印
            return;
        }

        uiHandler.post(new Runnable() {
            @Override
            public void run() {
                final IZegoEventHandler mEventHandler = eventHandler;
                if (mEventHandler != null) {
                    mEventHandler.onDebugError(errorCode, funcName, info);
                }
            }
        });
    }

    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        int errorCode = ZegoExpressEngineJniAPI.sendCustomAudioCapturePCMDataJni(data, dataLength, param.sampleRate.value(), param.channel.value(), channel == null ? ZegoPublishChannel.MAIN.value() : channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_AUDIO_IO, "sendCustomAudioCapturePCMData", errorCode, false);
        }
    }

    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        int errorCode = ZegoExpressEngineJniAPI.sendCustomAudioCaptureAACDataJni(data, dataLength, configLength, referenceTimeMillisecond, param.sampleRate.value(), param.channel.value(), channel == null ? ZegoPublishChannel.MAIN.value() : channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_AUDIO_IO, "sendCustomAudioCaptureAACData", errorCode, false);
        }
    }


    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        sendCustomAudioCapturePCMData(data, dataLength, param, ZegoPublishChannel.MAIN);
    }

    public void fetchCustomAudioRenderPCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        if (param == null) {
            param = new ZegoAudioFrameParam();
        }
        int errorCode = ZegoExpressEngineJniAPI.fetchCustomAudioRenderPCMDataJni(data, dataLength, param.sampleRate.value(), param.channel.value());
        if (errorCode != 0) {
            ZegoExpressEngineInternalImpl.printDebugInfoEx((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoInnerModule.CUSTOM_AUDIO_IO, "fetchCustomAudioRenderPCMData", errorCode, false);
        }
    }

    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config, ZegoPublishChannel channel) {
        if (config == null) {
            config = new ZegoCustomAudioConfig();
        }
        int errorCode = ZegoExpressEngineJniAPI.enableCustomAudioIOJni(enable, config.sourceType.value(), channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.CUSTOM_AUDIO_IO, "enableCustomAudioIO", errorCode);
    }

    @Override
    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param) {
        sendCustomAudioCaptureAACData(data, dataLength, configLength, referenceTimeMillisecond, param, ZegoPublishChannel.MAIN);
    }

    public void startRecordingCapturedData(ZegoDataRecordConfig config, ZegoPublishChannel channel) {
        if (config == null) {
            config = new ZegoDataRecordConfig();
        }
        if (config.recordType == null){
            config.recordType = ZegoDataRecordType.DEFAULT;
        }
        int errorCode = ZegoExpressEngineJniAPI.startRecordingCapturedDataJni(config.filePath, config.recordType.value(), channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.RECODER, "startRecordingCapturedData", errorCode);
    }

    public void stopRecordingCapturedData(ZegoPublishChannel channel) {
        int errorCode = ZegoExpressEngineJniAPI.stopRecordingCapturedDataJni(channel != null ? channel.value() : ZegoPublishChannel.MAIN.value());
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.RECODER, "stopRecordingCapturedData", errorCode);
    }

    public void setDataRecordEventHandler(IZegoDataRecordEventHandler handler) {
        iZegoDataRecordEventHandler = handler;
    }


    public void enableCustomAudioCaptureProcessing(boolean enable, ZegoCustomAudioProcessConfig config) {
        int samples = 0;
        int channel = 0;
        int sampleRate = 0;
        if (config != null) {
            samples = config.samples;
            channel = config.channel.value();
            sampleRate = config.sampleRate.value();
        }
        ZegoExpressEngineJniAPI.enableCustomAudioCaptureProcessingJni(enable, samples, channel, sampleRate);
    }

    public void enableCustomAudioRemoteProcessing(boolean enable, ZegoCustomAudioProcessConfig config) {
        int samples = 0;
        int channel = 0;
        int sampleRate = 0;
        if (config != null) {
            samples = config.samples;
            channel = config.channel.value();
            sampleRate = config.sampleRate.value();
        }
        ZegoExpressEngineJniAPI.enableCustomAudioRemoteProcessingJni(enable, samples, channel, sampleRate);
    }

    /* Private methods used by the upper framework */

    private static void setPlatformLanguage(int platform) {
        ZegoExpressEngineJniAPI.setPlatformLanguageJni(platform);
    }

    private static void logNotice(String log, String module) {
        ZegoExpressEngineJniAPI.logNoticeJni(log, module);
    }
    public void testNetworkConnectivity(IZegoTestNetworkConnectivityCallback callback){
        int seq = ZegoExpressEngineJniAPI.testNetworkConnectivityJni();
        synchronized (ZegoExpressEngineInternalImpl.class) {
            sTestNetworkConnectivityHandler.put(seq, callback);
        }
        ZegoExpressEngineInternalImpl.printDebugInfo( ZegoDebugLevel.INFO ,
                ZegoInnerModule.UTILITIES, "testNetworkConnectivity", 0);

    }
    public  void startNetworkSpeedTest(ZegoNetworkSpeedTestConfig config){
        int errorCode = ZegoExpressEngineJniAPI.startNetworkSpeedTest(config);
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.UTILITIES, "startNetworkSpeedTest", errorCode);

    }
    public void stopNetworkSpeedTest(){
        int errorCode = ZegoExpressEngineJniAPI.stopNetworkSpeedTest();
        ZegoExpressEngineInternalImpl.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.UTILITIES, "stopNetworkSpeedTest", errorCode);

    }
}
