package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoDataRecordEventHandler {

    /**
     * The callback triggered when the state of data recording (to a file) changes.
     *
     * @param state File recording status, according to which you should determine the state of the file recording or the prompt of the UI.
     * @param errorCode Error code, please refer to the error codes document https://doc-en.zego.im/en/5548.html for details.
     * @param config Record config
     * @param channel Publishing stream channel
     */
    public void onCapturedDataRecordStateUpdate(ZegoDataRecordState state, int errorCode, ZegoDataRecordConfig config, ZegoPublishChannel channel){

    }

    /**
     * The callback to report the current recording progress.
     *
     * @param progress File recording progress, which allows developers to hint at the UI, etc.
     * @param config Record config
     * @param channel Publishing stream channel
     */
    public void onCapturedDataRecordProgressUpdate(ZegoDataRecordProgress progress, ZegoDataRecordConfig config, ZegoPublishChannel channel){

    }

}

