package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoCustomAudioProcessHandler {

    /**
     * Custom audio processing local captured PCM audio frame callback.
     *
     * @param data Audio frame data.
     * @param dataLength Audio framw data length.
     * @param param Audio frame parameters.
     */
    public void onProcessCapturedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * Custom audio processing remote playing stream PCM audio frame callback.
     *
     * @param data Audio frame data.
     * @param dataLength Audio frame data length.
     * @param param Audio frame parameters.
     * @param streamID Stream ID
     */
    public void onProcessRemoteAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, String streamID){

    }

}

