/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import com.zego.ve.CameraAvailabilityCallback;
import com.zego.ve.Log;
import com.zego.ve.PermissionChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VCam {
    private static final String TAG = "vcap";
    private static final int FOCUS_MODE_AUTO = 0;
    private static final int FOCUS_MODE_INFINITY = 1;
    private static final int FOCUS_MODE_MACRO = 2;
    private static final int FOCUS_MODE_FIXED = 3;
    private static final int FOCUS_MODE_EDOF = 4;
    private static final int FOCUS_MODE_CONTINUOUS_VIDEO = 5;
    private static final int FOCUS_MODE_CONTINUOUS_PICTURE = 6;
    private static final int EXPOSURE_MODE_AUTO = 0;
    private static final int EXPOSURE_MODE_CUSTOM = 1;
    private static final int SCENE_MODE_NONE = 0;
    private static final int SCENE_MODE_LOW_LIGHT = 1;
    private static final int SCENE_MODE_NIGHT = 2;
    private static final int SCENE_MODE_ACTION = 3;
    private static final int SCENE_MODE_PORTRAIT = 4;
    private long mThis = 0L;
    private Context mContext = null;
    private CameraAvailabilityCallback mCameraAvailabilityCallback = null;
    private Camera mCam = null;
    private Camera.CameraInfo mCamInfo = null;
    int mWidth = 640;
    int mHeight = 480;
    int mFrameRate = 15;
    boolean mNeedHack = false;
    int mFocusMode = -1;
    int mExposureMode = -1;
    float mExposureCompensation = 0.0f;
    float mFocusPointX = 0.0f;
    float mFocusPointY = 0.0f;
    float mExposurePointX = 0.0f;
    float mExposurePointY = 0.0f;
    int mFrontCameraId = -1;
    int mBackCameraId = -1;
    int mUseCameraId = -1;
    int mFPSMode = 0;
    boolean mUseFaceDetection = false;
    boolean mIsFocusing = false;
    int mAreaSize = 0;
    private Matrix matrix = new Matrix();
    int mSceneMode = 0;

    private String GetCameraString(int n) {
        return n == this.mFrontCameraId ? "front camera" : "back camera";
    }

    private static native void onCameraAvailable(long var0);

    private static native void onCameraUnavailable(long var0);

    int setSize(int n, int n2) {
        if (n < n2) {
            this.mWidth = n2;
            this.mHeight = n;
        } else {
            this.mWidth = n;
            this.mHeight = n2;
        }
        this.mNeedHack = false;
        return 0;
    }

    int setRate(int n, int n2) {
        this.mFPSMode = n2;
        if (this.mFPSMode == 0) {
            return 0;
        }
        if (this.mFPSMode == 1) {
            n = 30;
        }
        this.mFrameRate = n;
        if (this.mCam != null) {
            Camera.Parameters parameters = this.mCam.getParameters();
            this.updateRate(n, parameters);
            try {
                this.mCam.setParameters(parameters);
            }
            catch (Exception exception) {
                android.util.Log.i((String)TAG, (String)"vcap: update fps -- set camera parameters error with exception");
                exception.printStackTrace();
            }
        }
        return 0;
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    int getFramerate() {
        return this.mFrameRate;
    }

    int getFront() {
        if (this.mCamInfo != null) {
            return this.mCamInfo.facing == 1 ? 1 : 0;
        }
        return 0;
    }

    int getOrientation() {
        if (this.mCamInfo != null) {
            return this.mCamInfo.orientation;
        }
        return 0;
    }

    int updateRate(int n, Camera.Parameters parameters) {
        List list = parameters.getSupportedPreviewFpsRange();
        if (list != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.mFrameRate * 1000;
            for (int[] nArray : list) {
                if (nArray[1] >= n4) {
                    if (n3 >= n4 && nArray[1] >= n3 && (nArray[1] != n3 || nArray[0] <= n2)) continue;
                    n2 = nArray[0];
                    n3 = nArray[1];
                    continue;
                }
                if (nArray[1] <= n3 && (nArray[1] != n3 || nArray[0] <= n2)) continue;
                n2 = nArray[0];
                n3 = nArray[1];
            }
            if (n3 != 0) {
                parameters.setPreviewFpsRange(n2, n3);
            }
        }
        int[] nArray = new int[2];
        parameters.getPreviewFpsRange(nArray);
        this.mFrameRate = nArray[0] == nArray[1] ? nArray[0] / 1000 : nArray[1] / 2 / 1000;
        Log.i(TAG, "real fps:| " + nArray[0] + "|" + nArray[1] + "|");
        return 0;
    }

    public int setContext(long l, Context context) {
        this.mThis = l;
        this.mContext = context;
        return 0;
    }

    private boolean isSupportCameraAvailabilityCallback() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=21)
    private void registerCameraAvailabilityCallback() {
        if (this.mContext != null) {
            try {
                CameraManager cameraManager = (CameraManager)this.mContext.getSystemService("camera");
                this.mCameraAvailabilityCallback = new CameraAvailabilityCallback(this.mThis, new CameraAvailabilityCallback.Listener(){

                    @Override
                    public void onCameraAvailable(long l, String string) {
                        Log.i(VCam.TAG, "trace interruption this: " + VCam.this + ", cameraId: " + string + " available" + ", mUseCameraId: " + VCam.this.mUseCameraId);
                        VCam.onCameraAvailable(l);
                    }

                    @Override
                    public void onCameraUnavailable(long l, String string) {
                        Log.i(VCam.TAG, "trace interruption this: " + VCam.this + ", cameraId: " + string + " unavailable" + ", mUseCameraId: " + VCam.this.mUseCameraId);
                        VCam.onCameraUnavailable(l);
                    }
                });
                cameraManager.registerAvailabilityCallback((CameraManager.AvailabilityCallback)this.mCameraAvailabilityCallback, null);
            }
            catch (Throwable throwable) {
                Log.e(TAG, "registerCameraAvailabilityCallback failed, " + throwable);
            }
        }
    }

    @TargetApi(value=21)
    private void unregisterCameraAvailabilityCallback() {
        if (this.mContext != null) {
            try {
                this.mCameraAvailabilityCallback.uninit();
                CameraManager cameraManager = (CameraManager)this.mContext.getSystemService("camera");
                cameraManager.unregisterAvailabilityCallback((CameraManager.AvailabilityCallback)this.mCameraAvailabilityCallback);
                this.mCameraAvailabilityCallback = null;
            }
            catch (Throwable throwable) {
                Log.e(TAG, "unregisterCameraAvailabilityCallback failed, " + throwable);
            }
        }
    }

    public int createCam(int n, int n2) {
        if (n == -1) {
            android.util.Log.e((String)TAG, (String)"vcap: invalid camera id");
            return -1;
        }
        this.mSceneMode = n2;
        android.util.Log.i((String)TAG, (String)("vcap -- board: " + Build.BOARD + " device: " + Build.DEVICE + " manufacturer: " + Build.MANUFACTURER + " brand: " + Build.BRAND + " model: " + Build.MODEL + " product: " + Build.PRODUCT + " sdk: " + Build.VERSION.SDK_INT + " cameraid:" + n));
        if (this.mCam != null) {
            return 0;
        }
        this.mCamInfo = new Camera.CameraInfo();
        try {
            this.mCam = Camera.open((int)n);
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)this.mCamInfo);
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "trace interruption open " + this.GetCameraString(n) + " failed, " + runtimeException);
            this.mCam = null;
        }
        this.mUseCameraId = n;
        if (this.mCam == null) {
            android.util.Log.w((String)TAG, (String)"vcap: no camera found, try default");
            try {
                this.mCam = Camera.open();
            }
            catch (RuntimeException runtimeException) {
                Log.e(TAG, "trace interruption open " + this.GetCameraString(this.mBackCameraId) + " failed, " + runtimeException);
                this.mCam = null;
            }
            if (this.mCam == null) {
                android.util.Log.e((String)TAG, (String)"vcap: no camera found");
                return -1;
            }
            Camera.getCameraInfo((int)this.mBackCameraId, (Camera.CameraInfo)this.mCamInfo);
            this.mUseCameraId = this.mBackCameraId;
        }
        boolean bl = false;
        Camera.Parameters parameters = this.mCam.getParameters();
        Camera.Size size = parameters.getPreferredPreviewSizeForVideo();
        boolean bl2 = this.mWidth >= 720 && this.mSceneMode != 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        List list = parameters.getSupportedVideoSizes();
        if (list == null) {
            list = parameters.getSupportedPreviewSizes();
        }
        if (list != null) {
            for (Camera.Size size2 : list) {
                android.util.Log.i((String)TAG, (String)("vcap: support size -- " + size2.width + "x" + size2.height));
                if (size2.width * size2.height <= n5 * n6 || size2.width * 3 != size2.height * 4 && size2.width * 9 != size2.height * 16) continue;
                n5 = size2.width;
                n6 = size2.height;
            }
            for (Camera.Size size2 : list) {
                if (size2.width % 16 != 0 || size2.height % 16 != 0 || bl2 && size2.width * size.height != size2.height * size.width) continue;
                if (size2.width >= this.mWidth && size2.height >= this.mHeight) {
                    if (n3 < this.mWidth || n4 < this.mHeight) {
                        n3 = size2.width;
                        n4 = size2.height;
                        continue;
                    }
                    if (size2.width * size2.height >= n3 * n4) continue;
                    n3 = size2.width;
                    n4 = size2.height;
                    continue;
                }
                if (size2.width >= this.mWidth) {
                    if (n3 >= this.mWidth && n4 >= this.mHeight) continue;
                    if (n3 < this.mWidth && n4 < this.mHeight) {
                        n3 = size2.width;
                        n4 = size2.height;
                        continue;
                    }
                    if (n3 >= this.mWidth && size2.height > n4) {
                        n3 = size2.width;
                        n4 = size2.height;
                        continue;
                    }
                    if (size2.width * size2.height <= n3 * n4) continue;
                    n3 = size2.width;
                    n4 = size2.height;
                    continue;
                }
                if (size2.height < this.mHeight || n3 >= this.mWidth && n4 >= this.mHeight) continue;
                if (n3 < this.mWidth && n4 < this.mHeight) {
                    n3 = size2.width;
                    n4 = size2.height;
                    continue;
                }
                if (n4 >= this.mHeight && size2.width > n3) {
                    n3 = size2.width;
                    n4 = size2.height;
                    continue;
                }
                if (size2.width * size2.height <= n3 * n4) continue;
                n3 = size2.width;
                n4 = size2.height;
            }
        }
        if (!bl) {
            if (n3 * n4 != 0) {
                parameters.setPreviewSize(n3, n4);
                this.mWidth = n3;
                this.mHeight = n4;
                bl = true;
            } else if (n5 * n6 != 0) {
                parameters.setPreviewSize(n5, n6);
                this.mWidth = n5;
                this.mHeight = n6;
                bl = true;
            } else {
                parameters.setPreviewSize(320, 240);
                this.mWidth = 320;
                this.mHeight = 240;
                bl = true;
            }
        }
        if (Build.MANUFACTURER.equals("Xiaomi") && Build.MODEL.equals("MI 4LTE") && Build.VERSION.SDK_INT <= 19 || this.mNeedHack) {
            android.util.Log.i((String)TAG, (String)"vcap: use prefer preview size");
            bl = false;
        }
        if (!bl && size != null) {
            parameters.setPreviewSize(size.width, size.height);
            this.mWidth = size.width;
            this.mHeight = size.height;
        }
        android.util.Log.i((String)TAG, (String)("vcap: preview size -- perferred:" + (size == null ? 0 : size.width) + "x" + (size == null ? 0 : size.height) + ", candidate:" + n3 + "x" + n4 + ", preview:" + this.mWidth + "x" + this.mHeight));
        if (this.mFPSMode != 0) {
            this.updateRate(this.mFrameRate, parameters);
        }
        parameters.setRecordingHint(bl2);
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)("vcap: set camera parameters error with exception width:" + parameters.getPreviewSize().width + " height:" + parameters.getPreviewSize().height + "."));
            exception.printStackTrace();
            this.mCam.release();
            this.mCam = null;
            if (this.mNeedHack) {
                return -1;
            }
            this.mNeedHack = true;
            return this.createCam(n, this.mSceneMode);
        }
        Camera.Parameters parameters2 = this.mCam.getParameters();
        this.mWidth = parameters2.getPreviewSize().width;
        this.mHeight = parameters2.getPreviewSize().height;
        this.mAreaSize = this.mWidth / 10;
        if (this.isSupportCameraAvailabilityCallback()) {
            this.registerCameraAvailabilityCallback();
        }
        return 0;
    }

    int startCam(boolean bl) {
        int n;
        Camera.Parameters parameters = this.mCam.getParameters();
        boolean bl2 = this.getFront() > 0;
        this.mUseFaceDetection = this.mCam.getParameters().getMaxNumDetectedFaces() > 0 && bl2 && bl;
        List list = parameters.getSupportedSceneModes();
        if (list != null) {
            n = 0;
            String string = "auto";
            if (1 == this.mSceneMode) {
                if (list.contains("party")) {
                    string = "party";
                } else if (list.contains("night")) {
                    string = "night";
                }
            } else if (2 == this.mSceneMode) {
                if (list.contains("night")) {
                    string = "night";
                }
            } else if (bl2 && 4 == this.mSceneMode) {
                if (list.contains("portrait")) {
                    string = "portrait";
                }
            } else if (!bl2 && 3 == this.mSceneMode) {
                if (list.contains("action")) {
                    string = "action";
                } else if (list.contains("sports")) {
                    string = "sports";
                }
            }
            try {
                n = 1;
                parameters.setSceneMode(string);
                Log.i(TAG, "vcap: set scene mode " + string);
            }
            catch (Exception exception) {
                n = 0;
                string = "auto";
                Log.e(TAG, "vcap: set scene mode failed");
                exception.printStackTrace();
            }
            if (n == 0 && list.contains(string)) {
                try {
                    n = 1;
                    parameters.setSceneMode(string);
                    Log.i(TAG, "vcap: set scene mode " + string);
                }
                catch (Exception exception) {
                    n = 0;
                    Log.e(TAG, "vcap: set scene mode failed");
                    exception.printStackTrace();
                }
            }
        }
        this.mIsFocusing = false;
        this.mCam.startPreview();
        this.mCam.cancelAutoFocus();
        if (this.mUseFaceDetection) {
            this.mCam.startFaceDetection();
        }
        if ((n = this.doSetFocusMode(this.mFocusMode, parameters)) >= 0) {
            if (!this.mUseFaceDetection) {
                this.doSetFocusPoint(this.mFocusPointX, this.mFocusPointY, parameters);
            }
        } else if (parameters.getMaxNumFocusAreas() > 0) {
            parameters.setFocusAreas(null);
        }
        if (this.doSetExposureMode(this.mExposureMode, parameters) == 0 && !this.mUseFaceDetection) {
            this.doSetExposurePoint(this.mExposurePointX, this.mExposurePointY, parameters);
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set focus & exposure failed");
            exception.printStackTrace();
        }
        if (n > 0) {
            this.mIsFocusing = true;
            this.mCam.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean bl, Camera camera) {
                    android.util.Log.e((String)VCam.TAG, (String)("vcap: set focus success:" + bl));
                    VCam.this.mIsFocusing = false;
                    camera.cancelAutoFocus();
                }
            });
        }
        return 0;
    }

    int stopCam() {
        if (this.mCam != null) {
            if (this.mUseFaceDetection) {
                this.mCam.stopFaceDetection();
            }
            this.mCam.stopPreview();
            try {
                this.mCam.setPreviewTexture(null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return 0;
    }

    int releaseCam() {
        if (this.isSupportCameraAvailabilityCallback()) {
            this.unregisterCameraAvailabilityCallback();
        }
        if (this.mCam != null) {
            this.mCam.release();
            this.mCam = null;
        }
        this.mCamInfo = null;
        this.mUseCameraId = -1;
        return 0;
    }

    int setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (this.mCam == null) {
            return -1;
        }
        try {
            this.mCam.setPreviewTexture(surfaceTexture);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    int openTorch() {
        if (this.mCam == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        boolean bl = false;
        if (parameters.getSupportedFlashModes().contains("torch")) {
            try {
                bl = true;
                parameters.setFlashMode("torch");
            }
            catch (Exception exception) {
                android.util.Log.e((String)TAG, (String)"vcap: set flash mode failed");
                exception.printStackTrace();
            }
        }
        if (!bl) {
            android.util.Log.i((String)TAG, (String)"vcap: vcap: flash mode left unset");
            return 0;
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set flash mode -- set camera parameters error with exception");
            exception.printStackTrace();
        }
        return 0;
    }

    int closeTorch() {
        if (this.mCam == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        boolean bl = false;
        if (parameters.getSupportedFlashModes().contains("off")) {
            try {
                bl = true;
                parameters.setFlashMode("off");
            }
            catch (Exception exception) {
                android.util.Log.e((String)TAG, (String)"vcap: set flash mode failed");
                exception.printStackTrace();
            }
        }
        if (!bl) {
            android.util.Log.i((String)TAG, (String)"vcap: flash mode left unset");
            return 0;
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set flash mode -- set camera parameters error with exception");
            exception.printStackTrace();
        }
        return 0;
    }

    int setFocusMode(int n) {
        this.mFocusMode = n;
        if (this.mCam == null) {
            return -1;
        }
        this.mCam.cancelAutoFocus();
        Camera.Parameters parameters = this.mCam.getParameters();
        int n2 = this.doSetFocusMode(this.mFocusMode, parameters);
        if (n2 >= 0) {
            if (!this.mUseFaceDetection) {
                this.doSetFocusPoint(this.mFocusPointX, this.mFocusPointY, parameters);
            }
        } else if (parameters.getMaxNumFocusAreas() > 0) {
            parameters.setFocusAreas(null);
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set focus mode -- set camera parameters error with exception");
            exception.printStackTrace();
            return -1;
        }
        if (n2 > 0) {
            this.mIsFocusing = true;
            this.mCam.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean bl, Camera camera) {
                    android.util.Log.e((String)VCam.TAG, (String)("vcap: set focus success:" + bl));
                    VCam.this.mIsFocusing = false;
                    camera.cancelAutoFocus();
                }
            });
        }
        return 0;
    }

    int doSetFocusMode(int n, Camera.Parameters parameters) {
        String string = null;
        switch (n) {
            case 0: {
                string = "auto";
                break;
            }
            case 1: {
                string = "infinity";
                break;
            }
            case 2: {
                string = "macro";
                break;
            }
            case 3: {
                string = "fixed";
                break;
            }
            case 4: {
                string = "edof";
                break;
            }
            case 5: {
                string = "continuous-video";
                break;
            }
            case 6: {
                string = "continuous-picture";
                break;
            }
            default: {
                string = "continuous-picture";
            }
        }
        boolean bl = false;
        List list = parameters.getSupportedFocusModes();
        if (list != null) {
            if (list.contains(string)) {
                try {
                    bl = true;
                    parameters.setFocusMode(string);
                    Log.i(TAG, "vcap: set focus mode " + string);
                }
                catch (Exception exception) {
                    Log.e(TAG, "vcap: set focus mode failed");
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                string = (String)list.get(0);
                try {
                    bl = true;
                    parameters.setFocusMode(string);
                    android.util.Log.i((String)TAG, (String)("vcap: fallback focus mode " + string));
                }
                catch (Exception exception) {
                    android.util.Log.e((String)TAG, (String)"vcap: fallback focus mode failed");
                    exception.printStackTrace();
                }
            }
        }
        if (!bl) {
            Log.i(TAG, "vcap: focus mode left unset");
            return -1;
        }
        boolean bl2 = false;
        if (string == "auto" || string == "macro") {
            bl2 = true;
        }
        return bl2 ? 1 : 0;
    }

    int setFocusPoint(float f, float f2) {
        this.mFocusPointX = f;
        this.mFocusPointY = f2;
        if (this.mCam == null || this.mUseFaceDetection || this.mIsFocusing) {
            return -1;
        }
        this.setFocusMode(0);
        return 0;
    }

    int doSetFocusPoint(float f, float f2, Camera.Parameters parameters) {
        if (parameters.getMaxNumFocusAreas() == 0) {
            android.util.Log.i((String)TAG, (String)"vcap: set focus areas not supported");
            return -1;
        }
        Rect rect = this.calculateArea(f, f2);
        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
        arrayList.add(new Camera.Area(rect, 800));
        try {
            parameters.setFocusAreas(arrayList);
            android.util.Log.i((String)TAG, (String)("vcap: set focus area " + rect.toString()));
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set focus areas failed");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    static int clamp(int n, int n2, int n3) {
        if (n > n3) {
            return n3;
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    static float clamp2(float f, float f2, float f3) {
        if (f > f3) {
            return f3;
        }
        if (f < f2) {
            return f2;
        }
        return f;
    }

    int setExposureMode(int n) {
        this.mExposureMode = n;
        if (this.mCam == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        if (this.doSetExposureMode(this.mExposureMode, parameters) != 0) {
            return -1;
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure mode -- set camera parameters error with exception");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    int doSetExposureMode(int n, Camera.Parameters parameters) {
        if (n == -1) {
            return 0;
        }
        if (!parameters.isAutoExposureLockSupported()) {
            android.util.Log.e((String)TAG, (String)"vcap: auto exposure lock not supported");
            return -1;
        }
        try {
            if (n == 0) {
                parameters.setAutoExposureLock(false);
            } else if (n == 1) {
                parameters.setAutoExposureLock(true);
            }
            android.util.Log.e((String)TAG, (String)("vcap: set exposure mode " + n));
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure mode failed");
            exception.printStackTrace();
        }
        this.doSetExposureCompensation(this.mExposureCompensation, parameters);
        return 0;
    }

    int setExposureCompensation(float f) {
        this.mExposureCompensation = f;
        if (this.mCam == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        if (this.doSetExposureCompensation(f, parameters) != 0) {
            return -1;
        }
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure compensation -- set camera parameters error with exception");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    int doSetExposureCompensation(float f, Camera.Parameters parameters) {
        int n = parameters.getMinExposureCompensation() * -1;
        int n2 = parameters.getMaxExposureCompensation();
        int n3 = (int)(f < 0.0f ? (float)n * f : (float)n2 * f);
        try {
            parameters.setExposureCompensation(n3);
            android.util.Log.i((String)TAG, (String)("vcap: set exposure compensation " + n3));
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure compensation failed");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    int setExposurePoint(float f, float f2) {
        this.mExposurePointX = f;
        this.mExposurePointY = f2;
        if (this.mCam == null || this.mUseFaceDetection) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure point -- skip");
            return -1;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        this.doSetExposurePoint(f, f2, parameters);
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure point -- set camera parameters error with exception");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    int doSetExposurePoint(float f, float f2, Camera.Parameters parameters) {
        if (parameters.getMaxNumMeteringAreas() == 0) {
            android.util.Log.i((String)TAG, (String)"vcap: set exposure areas not supported");
            return -1;
        }
        Rect rect = this.calculateArea(f, f2);
        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
        arrayList.add(new Camera.Area(rect, 800));
        try {
            parameters.setMeteringAreas(arrayList);
            android.util.Log.i((String)TAG, (String)("vcap: set exposure area " + rect.toString()));
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set exposure areas failed");
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }

    void enumerateCamera() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int n = Camera.getNumberOfCameras();
        for (int i = 0; i < n; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 0 && this.mBackCameraId == -1) {
                this.mBackCameraId = i;
            }
            if (cameraInfo.facing != 1 || this.mFrontCameraId != -1) continue;
            this.mFrontCameraId = i;
        }
        Log.i(TAG, "trace interruption enumerateCamera this: " + this + ", mFrontCameraId: " + this.mFrontCameraId + ", mBackCameraId: " + this.mBackCameraId);
    }

    int getFrontCameraId() {
        return this.mFrontCameraId;
    }

    int getBackCameraId() {
        return this.mBackCameraId;
    }

    boolean isSamsung() {
        return "samsung".equals(Build.MANUFACTURER.toLowerCase());
    }

    boolean checkPermission() {
        return PermissionChecker.checkSelfPermission(this.mContext, "android.permission.CAMERA");
    }

    int getMaxZoomRatio() {
        if (this.mCam == null) {
            return 100;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        if (!parameters.isZoomSupported()) {
            return 100;
        }
        List list = parameters.getZoomRatios();
        if (list.size() == 0) {
            return 100;
        }
        return (Integer)list.get(parameters.getMaxZoom());
    }

    void setZoomFactor(float f) {
        if (this.mCam == null) {
            return;
        }
        Camera.Parameters parameters = this.mCam.getParameters();
        if (!parameters.isZoomSupported()) {
            return;
        }
        List list = parameters.getZoomRatios();
        if (list.size() == 0) {
            return;
        }
        int n = (int)(f * 100.0f);
        int n2 = 0;
        if (n != 100) {
            for (int i = 1; i < list.size(); ++i) {
                if ((Integer)list.get(i) < n) continue;
                n2 = i;
                break;
            }
        }
        parameters.setZoom(n2);
        try {
            this.mCam.setParameters(parameters);
        }
        catch (Exception exception) {
            android.util.Log.e((String)TAG, (String)"vcap: set zoom failed");
            exception.printStackTrace();
        }
    }

    private Rect calculateArea(float f, float f2) {
        float f3 = (float)this.mAreaSize / (float)this.mWidth * 2.0f;
        float f4 = (float)this.mAreaSize / (float)this.mHeight * 2.0f;
        float f5 = VCam.clamp2(f - f3 / 2.0f, -1.0f, 1.0f - f3);
        float f6 = VCam.clamp2(f2 - f4 / 2.0f, -1.0f, 1.0f - f4);
        return new Rect(VCam.clamp((int)(f5 * 1000.0f), -1000, 1000), VCam.clamp((int)(f6 * 1000.0f), -1000, 1000), VCam.clamp((int)((f5 + f3) * 1000.0f), -1000, 1000), VCam.clamp((int)((f6 + f4) * 1000.0f), -1000, 1000));
    }
}

