/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.zego.ve.HwAudioKaraokeFeatureKit;
import com.zego.ve.IAudioKitCallback;

class FeatureKitManager {
    private static final Object SET_CALL_BACK_LOCK = new Object();
    private static final Object NEW_FEATUREMANAGER_LOCK = new Object();
    private static final Object BIND_SERVICE_LOCK = new Object();
    private static final Object UNBIND_SERVICE_LOCK = new Object();
    private static FeatureKitManager sInstance = null;
    private IAudioKitCallback mCallBack = null;

    private FeatureKitManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FeatureKitManager getInstance() {
        Object object = NEW_FEATUREMANAGER_LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new FeatureKitManager();
            }
            return sInstance;
        }
    }

    protected HwAudioKaraokeFeatureKit createFeatureKit(int n, Context context) {
        if (context == null) {
            return null;
        }
        switch (n) {
            case 1: {
                HwAudioKaraokeFeatureKit hwAudioKaraokeFeatureKit = new HwAudioKaraokeFeatureKit(context);
                hwAudioKaraokeFeatureKit.initialize(context);
                return hwAudioKaraokeFeatureKit;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindService(Context context, ServiceConnection serviceConnection, String string) {
        Object object = BIND_SERVICE_LOCK;
        synchronized (object) {
            if (context != null) {
                Intent intent = new Intent();
                intent.setClassName("com.huawei.multimedia.audioengine", string);
                try {
                    context.bindService(intent, serviceConnection, 1);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindService(Context context, ServiceConnection serviceConnection) {
        Object object = UNBIND_SERVICE_LOCK;
        synchronized (object) {
            if (context != null) {
                context.unbindService(serviceConnection);
            }
        }
    }

    protected boolean isMediaKitSupport(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo;
            return packageManager == null || (packageInfo = packageManager.getPackageInfo("com.huawei.multimedia.audioengine", 0)) != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallBack(int n) {
        Object object = SET_CALL_BACK_LOCK;
        synchronized (object) {
            if (this.getCallBack() != null) {
                this.getCallBack().onResult(n);
            }
        }
    }

    protected void setCallBack(IAudioKitCallback iAudioKitCallback) {
        this.mCallBack = iAudioKitCallback;
    }

    protected IAudioKitCallback getCallBack() {
        return this.mCallBack;
    }
}

