package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Audio reverberation parameters
 *
 * Developers can use the SDK's built-in presets to change the parameters of the reverb.
 */
public class ZegoReverbParam {

    /** Reverb Damping, range [0.0, 2.0], controls the attenuation of the reverb, the higher the damping, the higher the attenuation. */
    public float damping;

    /** Dry/wet ratio, the range is greater than or equal to 0.0, to control the ratio between reverberation, direct sound and early reflections; dry part is set to 1 by default; the smaller the dry/wet ratio, the larger the wet ratio, the stronger the reverberation effect. */
    public float dryWetRatio;

    /** Echo, in the range [0.0, 0.5], to control the trailing length of the reverb. */
    public float reverberance;

    /** Room size, in the range [0.0, 1.0], to control the size of the "room" in which the reverb is generated, the larger the room, the stronger the reverb. */
    public float roomSize;

    /**
     * Create reverb param configuration with preset enumeration values
     */
    public ZegoReverbParam(ZegoReverbPreset preset){
        if (preset == ZegoReverbPreset.SOFT_ROOM) {
            this.roomSize = 0.6f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 2.5f;
        } else if (preset == ZegoReverbPreset.LARGE_ROOM) {
            this.roomSize = 0.65f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 0.94f;
        } else if (preset == ZegoReverbPreset.CONCER_HALL) {
            this.roomSize = 0.8f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 1.1f;
        } else if (preset == ZegoReverbPreset.VALLEY) {
            this.roomSize = 0.85f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 0.92f;
        } else if (preset == ZegoReverbPreset.NONE) {
            this.roomSize = 0f;
            this.reverberance = 0f;
            this.damping = 0f;
            this.dryWetRatio = 0f;
        } else if (preset == null) {
            this.roomSize = 0f;
            this.reverberance = 0f;
            this.damping = 0f;
            this.dryWetRatio = 0f;
        }
    }

    public ZegoReverbParam(){
        this(ZegoReverbPreset.NONE);
    }

}
