package im.zego.zegoexpress.constants;

/** Record type */
public enum ZegoDataRecordType {
    /** This field indicates that the audio-only SDK records audio by default, and the audio and video SDK records audio and video by default. */
    DEFAULT(0),
    /** only record audio */
    ONLY_AUDIO(1),
    /** only record video, Audio-only SDK is invalid. */
    ONLY_VIDEO(2),
    /** record audio and video, Audio-only SDK will be recorded only audio. */
    AUDIO_AND_VIDEO(3);

    private int value;

    private ZegoDataRecordType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoDataRecordType getZegoDataRecordType(int value) {
        try {

            if (DEFAULT.value == value) {
                return DEFAULT;
            }

            if (ONLY_AUDIO.value == value) {
                return ONLY_AUDIO;
            }

            if (ONLY_VIDEO.value == value) {
                return ONLY_VIDEO;
            }

            if (AUDIO_AND_VIDEO.value == value) {
                return AUDIO_AND_VIDEO;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}