package im.zego.zegoexpress.constants;

/** Audio data callback interface enable bitmask enumeration */
public enum ZegoAudioDataCallbackBitMask {
    /** The mask bit of this field corresponds to the enable [onCapturedAudioData] callback interface */
    CAPTURED(1 << 0),
    /** The mask bit of this field corresponds to the enable [onPlaybackAudioData] callback interface */
    PLAYBACK(1 << 1),
    /** The mask bit of this field corresponds to the enable [onMixedAudioData] callback interface */
    MIXED(1 << 2);

    private int value;

    private ZegoAudioDataCallbackBitMask(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoAudioDataCallbackBitMask getZegoAudioDataCallbackBitMask(int value) {
        try {

            if (CAPTURED.value == value) {
                return CAPTURED;
            }

            if (PLAYBACK.value == value) {
                return PLAYBACK;
            }

            if (MIXED.value == value) {
                return MIXED;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}